// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 61 1.6.1.5 source/core/collect/iiexc.h, collection, ioc.v400, 980918 
#ifndef _IIEXC_
#define _IIEXC_

#include <iiglobal.h>
#include <iexc.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)


#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

class IC_EXPORTC IFullExceptionImpl : public IFullException
{
public:
    typedef IFullException InheritedIBM;
public:

           IFullExceptionImpl
                            (char const*);

           IFullExceptionImpl
                            (char const*, char const*,
                             char const*, unsigned long,
                             unsigned long);

           IFullExceptionImpl
                            (IFullExceptionImpl const&);

          ~IFullExceptionImpl
                            ();

static
  void     throwIt
                            (char const*, char const*,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (IFullExceptionImpl const&);

};

class IC_EXPORTC IEmptyExceptionImpl : public IEmptyException
{
public:
    typedef IEmptyException InheritedIBM;
public:

           IEmptyExceptionImpl
                            (char const*);

           IEmptyExceptionImpl
                            (char const*, char const*,
                             char const*, unsigned long,
                             unsigned long);

           IEmptyExceptionImpl
                            (IEmptyExceptionImpl const&);

          ~IEmptyExceptionImpl
                            ();

static
  void     throwIt
                            (char const*, char const*,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (IEmptyExceptionImpl const&);

};

class IC_EXPORTC INotEmptyExceptionImpl : public INotEmptyException
{
public:
    typedef INotEmptyException InheritedIBM;
public:

           INotEmptyExceptionImpl
                            (char const*);

           INotEmptyExceptionImpl
                            (char const*, char const*,
                             char const*, unsigned long,
                             unsigned long);

           INotEmptyExceptionImpl
                            (INotEmptyExceptionImpl const&);

          ~INotEmptyExceptionImpl
                            ();

static
  void     throwIt
                            (char const*, char const*,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (INotEmptyExceptionImpl const&);

};

class IC_EXPORTC INotBoundedExceptionImpl : public INotBoundedException
{
public:
    typedef INotBoundedException InheritedIBM;
public:

           INotBoundedExceptionImpl
                            (char const*);

           INotBoundedExceptionImpl
                            (char const*, char const*,
                             char const*, unsigned long,
                             unsigned long);

           INotBoundedExceptionImpl
                            (INotBoundedExceptionImpl const&);

          ~INotBoundedExceptionImpl
                            ();

static
  void     throwIt
                            (char const*, char const*,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (INotBoundedExceptionImpl const&);

};

class IC_EXPORTC ICursorInvalidExceptionImpl : public ICursorInvalidException
{
public:
    typedef ICursorInvalidException InheritedIBM;
public:

           ICursorInvalidExceptionImpl
                            (char const*);

           ICursorInvalidExceptionImpl
                            (char const*, char const*,
                             char const*, unsigned long,
                             unsigned long);

           ICursorInvalidExceptionImpl
                            (ICursorInvalidExceptionImpl const&);

          ~ICursorInvalidExceptionImpl
                            ();

static
  void     throwIt
                            (char const*, char const*,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (ICursorInvalidExceptionImpl const&);

};

class IC_EXPORTC ICursorNotForThisExceptionImpl : public ICursorInvalidException
{
public:
    typedef ICursorInvalidException InheritedIBM;
public:

           ICursorNotForThisExceptionImpl
                            (char const*);

           ICursorNotForThisExceptionImpl
                            (char const*, char const*,
                             char const*, unsigned long,
                             unsigned long);

           ICursorNotForThisExceptionImpl
                            (ICursorNotForThisExceptionImpl const&);

          ~ICursorNotForThisExceptionImpl
                            ();

static
  void     throwIt
                            (char const*, char const*,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (ICursorNotForThisExceptionImpl const&);

};

class IC_EXPORTC ICursorNotForGivenExceptionImpl : public ICursorInvalidException
{
public:
    typedef ICursorInvalidException InheritedIBM;
public:

           ICursorNotForGivenExceptionImpl
                            (char const*);

           ICursorNotForGivenExceptionImpl
                            (char const*, char const*,
                             char const*, unsigned long,
                             unsigned long);

           ICursorNotForGivenExceptionImpl
                            (ICursorNotForGivenExceptionImpl const&);

          ~ICursorNotForGivenExceptionImpl
                            ();

static
  void     throwIt
                            (char const*, char const*,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (ICursorNotForGivenExceptionImpl const&);

};

class IC_EXPORTC ICursorNotContainedExceptionImpl : public ICursorInvalidException
{
public:
    typedef ICursorInvalidException InheritedIBM;
public:

           ICursorNotContainedExceptionImpl
                            (char const*);

           ICursorNotContainedExceptionImpl
                            (char const*, char const*,
                             char const*, unsigned long,
                             unsigned long);

           ICursorNotContainedExceptionImpl
                            (ICursorNotContainedExceptionImpl const&);

          ~ICursorNotContainedExceptionImpl
                            ();

static
  void     throwIt
                            (char const*, char const*,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (ICursorNotContainedExceptionImpl const&);

};

class IC_EXPORTC IPositionInvalidExceptionImpl : public IPositionInvalidException
{
public:
    typedef IPositionInvalidException InheritedIBM;
public:

           IPositionInvalidExceptionImpl
                            (char const*);

           IPositionInvalidExceptionImpl
                            (char const*, char const*,
                             char const*, unsigned long,
                             unsigned long);

           IPositionInvalidExceptionImpl
                            (IPositionInvalidExceptionImpl const&);

          ~IPositionInvalidExceptionImpl
                            ();

static
  void     throwIt
                            (char const*, char const*,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (IPositionInvalidExceptionImpl const&);

};

class IC_EXPORTC INotContainsKeyExceptionImpl : public INotContainsKeyException
{
public:
    typedef INotContainsKeyException InheritedIBM;
public:

           INotContainsKeyExceptionImpl
                            (char const*);

           INotContainsKeyExceptionImpl
                            (char const*, char const*,
                             char const*, unsigned long,
                             unsigned long);

           INotContainsKeyExceptionImpl
                            (INotContainsKeyExceptionImpl const&);

          ~INotContainsKeyExceptionImpl
                            ();

static
  void     throwIt
                            (char const*, char const*,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (INotContainsKeyExceptionImpl const&);

};

class IC_EXPORTC IKeyAlreadyExistsExceptionImpl : public IKeyAlreadyExistsException
{
public:
    typedef IKeyAlreadyExistsException InheritedIBM;
public:

           IKeyAlreadyExistsExceptionImpl
                            (char const*);

           IKeyAlreadyExistsExceptionImpl
                            (char const*, char const*,
                             char const*, unsigned long,
                             unsigned long);

           IKeyAlreadyExistsExceptionImpl
                            (IKeyAlreadyExistsExceptionImpl const&);

          ~IKeyAlreadyExistsExceptionImpl
                            ();

static
  void     throwIt
                            (char const*, char const*,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (IKeyAlreadyExistsExceptionImpl const&);

};

class IC_EXPORTC IRootAlreadyExistsExceptionImpl : public IRootAlreadyExistsException
{
public:
    typedef IRootAlreadyExistsException InheritedIBM;
public:

           IRootAlreadyExistsExceptionImpl
                            (char const*);

           IRootAlreadyExistsExceptionImpl
                            (char const*, char const*,
                             char const*, unsigned long,
                             unsigned long);

           IRootAlreadyExistsExceptionImpl
                            (IRootAlreadyExistsExceptionImpl const&);

          ~IRootAlreadyExistsExceptionImpl
                            ();

static
  void     throwIt
                            (char const*, char const*,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (IRootAlreadyExistsExceptionImpl const&);

};

class IC_EXPORTC IChildAlreadyExistsExceptionImpl : public IChildAlreadyExistsException
{
public:
    typedef IChildAlreadyExistsException InheritedIBM;
public:

           IChildAlreadyExistsExceptionImpl
                            (char const*);

           IChildAlreadyExistsExceptionImpl
                            (char const*, char const*,
                             char const*, unsigned long,
                             unsigned long);

           IChildAlreadyExistsExceptionImpl
                            (IChildAlreadyExistsExceptionImpl const&);

          ~IChildAlreadyExistsExceptionImpl
                            ();

static
  void     throwIt
                            (char const*, char const*,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (IChildAlreadyExistsExceptionImpl const&);

};

class IC_EXPORTC IIdenticalCollectionExceptionImpl : public IIdenticalCollectionException
{
public:
    typedef IIdenticalCollectionException InheritedIBM;
public:

           IIdenticalCollectionExceptionImpl
                            (char const*);

           IIdenticalCollectionExceptionImpl
                            (char const*, char const*,
                             char const*, unsigned long,
                             unsigned long);

           IIdenticalCollectionExceptionImpl
                            (IIdenticalCollectionExceptionImpl const&);

          ~IIdenticalCollectionExceptionImpl
                            ();

static
  void     throwIt
                            (char const*, char const*,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (IIdenticalCollectionExceptionImpl const&);

};

class IC_EXPORTC IInvalidReplacementExceptionImpl : public IInvalidReplacementException
{
public:
    typedef IInvalidReplacementException InheritedIBM;
public:

           IInvalidReplacementExceptionImpl
                            (char const*);

           IInvalidReplacementExceptionImpl
                            (char const*, char const*,
                             char const*, unsigned long,
                             unsigned long);

           IInvalidReplacementExceptionImpl
                            (IInvalidReplacementExceptionImpl const&);

          ~IInvalidReplacementExceptionImpl
                            ();

static
  void     throwIt
                            (char const*, char const*,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (IInvalidReplacementExceptionImpl const&);

};

class IC_EXPORTC ICyclicAttachExceptionImpl : public ICyclicAttachException
{
public:
    typedef ICyclicAttachException InheritedIBM;
public:

           ICyclicAttachExceptionImpl
                            (char const*);

           ICyclicAttachExceptionImpl
                            (char const*, char const*,
                             char const*, unsigned long,
                             unsigned long);

           ICyclicAttachExceptionImpl
                            (ICyclicAttachExceptionImpl const&);

          ~ICyclicAttachExceptionImpl
                            ();

static
  void     throwIt
                            (char const*, char const*,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (ICyclicAttachExceptionImpl const&);

};

class IC_EXPORTC IOutOfCollectionMemoryImpl : public IOutOfCollectionMemory
{
public:
    typedef IOutOfCollectionMemory InheritedIBM;
public:

           IOutOfCollectionMemoryImpl
                            (char const*);

           IOutOfCollectionMemoryImpl
                            (char const*, char const*,
                             char const*, unsigned long,
                             unsigned long);

           IOutOfCollectionMemoryImpl
                            (IOutOfCollectionMemoryImpl const&);

          ~IOutOfCollectionMemoryImpl
                            ();

static
  void     throwIt
                            (char const*, char const*,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (IOutOfCollectionMemoryImpl const&);

};


class IC_EXPORTC ICollectionResourceExceptionImpl : public ICollectionResourceException
{
public:
    typedef ICollectionResourceException InheritedIBM;
public:

           ICollectionResourceExceptionImpl
                            (char const*);

           ICollectionResourceExceptionImpl
                            (char const*, char const*,
                             char const*, unsigned long,
                             unsigned long);

           ICollectionResourceExceptionImpl
                            (ICollectionResourceExceptionImpl const&);

          ~ICollectionResourceExceptionImpl
                            ();

static
  void     throwIt
                            (char const*, char const*,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (ICollectionResourceExceptionImpl const&);

};

class IC_EXPORTC ICollectionLockExceptionImpl : public ICollectionLockException
{
public:
    typedef ICollectionLockException InheritedIBM;
public:

           ICollectionLockExceptionImpl
                            (char const*);

           ICollectionLockExceptionImpl
                            (char const*, char const*,
                             char const*, unsigned long,
                             unsigned long);

           ICollectionLockExceptionImpl
                            (ICollectionLockExceptionImpl const&);

          ~ICollectionLockExceptionImpl
                            ();

static
  void     throwIt
                            (char const*, char const*,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (ICollectionLockExceptionImpl const&);

};

class IC_EXPORTC ICollectionLockTimeOutExceptionImpl : public ICollectionLockTimeOutException
{
public:
    typedef ICollectionLockTimeOutException InheritedIBM;
public:

           ICollectionLockTimeOutExceptionImpl
                            (char const*);

           ICollectionLockTimeOutExceptionImpl
                            (char const*, char const*,
                             char const*, unsigned long,
                             unsigned long);

           ICollectionLockTimeOutExceptionImpl
                            (ICollectionLockTimeOutExceptionImpl const&);

          ~ICollectionLockTimeOutExceptionImpl
                            ();

static
  void     throwIt
                            (char const*, char const*,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (ICollectionLockTimeOutExceptionImpl const&);

};

class IC_EXPORTC ICollectionUnlockExceptionImpl : public ICollectionUnlockException
{
public:
    typedef ICollectionUnlockException InheritedIBM;
public:

           ICollectionUnlockExceptionImpl
                            (char const*);

           ICollectionUnlockExceptionImpl
                            (char const*, char const*,
                             char const*, unsigned long,
                             unsigned long);

           ICollectionUnlockExceptionImpl
                            (ICollectionUnlockExceptionImpl const&);

          ~ICollectionUnlockExceptionImpl
                            ();

static
  void     throwIt
                            (char const*, char const*,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (ICollectionUnlockExceptionImpl const&);

};






































#if ! defined (__INO_STREAMING__)
class IC_EXPORTC IStreamErrorExceptionImpl : public IStreamErrorException
{
public:
    typedef IStreamErrorException InheritedIBM;
public:

           IStreamErrorExceptionImpl
                            (char const*);

           IStreamErrorExceptionImpl
                            (char const*, char const*,
                             char const*, unsigned long,
                             unsigned long);

           IStreamErrorExceptionImpl
                            (IStreamErrorExceptionImpl const&);

          ~IStreamErrorExceptionImpl
                            ();

static
  void     throwIt
                            (char const*, char const*,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (IStreamErrorExceptionImpl const&);

};

class IC_EXPORTC IStreamerInvalidExceptionImpl : public IStreamerInvalidException
{
public:
    typedef IStreamerInvalidException InheritedIBM;
public:

           IStreamerInvalidExceptionImpl
                            (char const*);

           IStreamerInvalidExceptionImpl
                            (char const*, char const*,
                             char const*, unsigned long,
                             unsigned long);

           IStreamerInvalidExceptionImpl
                            (IStreamerInvalidExceptionImpl const&);

          ~IStreamerInvalidExceptionImpl
                            ();

static
  void     throwIt
                            (char const*, char const*,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (IStreamerInvalidExceptionImpl const&);

};
#endif

#pragma enum(pop)
#pragma pack(pop)

#if (INO_EXCEPTIONS_SUPPORT)

  #define ITRY if (true)
  #define IENDTRY
  #define ICATCH(exc) if (false)
  #define IENDCATCH

#else

  #define ITRY try
  #define IENDTRY
  #define ICATCH(exc) catch (exc)
  #define IENDCATCH

#endif

#if ! defined (IASSERT)
#define IASSERT(exp)
#endif

#define ICHECK(pre, exc, cn, mn)\
  { if (! (pre))\
      exc::throwIt (cn, mn, __FILE__, __LINE__);\
  }

#define ICHECK_Memory(Class, Method) \
  ICHECK (result != 0,\
          IOutOfCollectionMemoryImpl,\
          Class, Method)

#define ICHECK_IsEmpty(Class, Method) \
  ICHECK (! this->IsEmpty (),\
          IEmptyExceptionImpl,\
          Class, Method)

#define ICHECK_IsFor(Class, Method) \
  ICHECK (cursor.IsFor (*this),\
          ICursorNotForThisExceptionImpl,\
          Class, Method)

#define ICHECK_IsForThat(Class, Method) \
  ICHECK (thatCursor.IsFor (tree),\
          ICursorNotForGivenExceptionImpl,\
          Class, Method)

#define ICHECK_Identical(Class, Method) \
  ICHECK (this != &collection,\
          IIdenticalCollectionExceptionImpl,\
          Class, Method)

#define ICHECK_IsValid(Class, Method) \
  ICHECK (cursor.IsValid (),\
          ICursorInvalidExceptionImpl,\
          Class, Method)

#define ICHECK_IsThatValid(Class, Method) \
  ICHECK (thatCursor.IsValid (),\
          ICursorInvalidExceptionImpl,\
          Class, Method)

#define ICHECK_Cursor(Class, Method) \
  ICHECK (this->CheckCursor (cursor),\
          ICursorNotContainedExceptionImpl,\
          Class, Method)

#define ICHECK_ThatCursor(Class, Method) \
  ICHECK (tree.CheckCursor (thatCursor),\
          ICursorNotContainedExceptionImpl,\
          Class, Method)

#define ICHECK_Child(Class, Method) \
  ICHECK (this->CheckChild (cursor, position),\
          IChildAlreadyExistsExceptionImpl,\
          Class, Method)

#define ICHECK_Root(Class, Method) \
  ICHECK (this->IsEmpty (),\
          IRootAlreadyExistsExceptionImpl,\
          Class, Method)

#define ICHECK_Position(Class, Method) \
  ICHECK (1 <= position && position <= this->NumberOfElements (),\
          IPositionInvalidExceptionImpl,\
          Class, Method)

#define ICHECK_Position2(Class, Method) \
  ICHECK (1 <= position && position <= this->NumberOfElements () + 1,\
          IPositionInvalidExceptionImpl,\
          Class, Method)

#define ICHECK_Position3(Class, Method) \
  ICHECK (1 <= position && position <= this->NumberOfChildren (),\
          IPositionInvalidExceptionImpl,\
          Class, Method)

#define ICHECK_ContainsKey(Class, Method) \
  ICHECK (this->LocateElementWithKey (key, cursor),\
          INotContainsKeyExceptionImpl,\
          Class, Method)

#define ICHECK_NotBounded(Class, Method) \
  {\
      INotBoundedExceptionImpl::throwIt (Class, Method, __FILE__, __LINE__);\
  }

#define ICHECK_Replacement(Class, Method) \
  ICHECK (this->CheckReplacement (cursor, element),\
          IInvalidReplacementExceptionImpl,\
          Class, Method)

#define ICHECK_Equality(Class, Method) \
  ICHECK (this->Contains (element),\
          IKeyAlreadyExistsExceptionImpl,\
          Class, Method)

#define ICHECK_Cycle(Class, Method) \
  ICHECK (this != &tree,\
          ICyclicAttachExceptionImpl,\
          Class, Method)

#define ICHECK_Cycle2(Class, Method) \
  ICHECK (this != &tree || \
          ! this->CheckCursor (cursor, thatCursor),\
          ICyclicAttachExceptionImpl,\
          Class, Method)

#define ICHECK_StreamInChildren(Class, Method) \
  ICHECK (n == numOfChildren, IStreamErrorExceptionImpl,\
          Class, Method)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#pragma info (restore)

#endif // _IIEXC_
