// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 55 1.6.1.3 source/core/collect/iiesseq.h, collection, ioc.v400, 980918 
#ifndef _IIESSEQ_
#define _IIESSEQ_

#include <ilanglvl.hpp>
#include <iiaes.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Base>
class IEqualitySequenceOnSequenceMngCursorImpl;

template <class Base>
class IEqualitySequenceOnSequenceImpl;

#pragma pack(push,4)
#pragma enum(4)

template <class Base>
class IC_EXPORTC IEqualitySequenceOnSequenceMngCursorImpl : public Base::MngCursor
{
  typedef TYPENAME Base::MngCursor Inherited;

public:

           IEqualitySequenceOnSequenceMngCursorImpl
                            (IEqualitySequenceOnSequenceImpl
                              <Base> const&);

          ~IEqualitySequenceOnSequenceMngCursorImpl
                            ();

protected:

private:










};

template <class Base>
class IAEqualitySequenceOnSequenceOps;

template <class Base>
class IC_EXPORTC IEqualitySequenceOnSequenceImpl :
  public IAEqualitySequenceImpl {

  typedef  IAEqualitySequenceImpl Inherited;

  typedef  IEqualitySequenceOnSequenceImpl <Base> Self;

public:

  typedef  IAEqualitySequenceOnSequenceOps <Base> Ops;

  typedef TYPENAME Base::Cursor Cursor;

  typedef  IEqualitySequenceOnSequenceMngCursorImpl <Base> MngCursor;

           IEqualitySequenceOnSequenceImpl
                            (Ops&, INumber);

           IEqualitySequenceOnSequenceImpl
                            (Ops&,
                             IEqualitySequenceOnSequenceImpl
                              <Base> const&);

          ~IEqualitySequenceOnSequenceImpl
                            ();

  bool Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  void     AddAsFirst       (void const*, ICursorImpl&);

  void     AddAsLast        (void const*, ICursorImpl&);

  void     AddAsNext        (void const*, ICursorImpl&);

  void     AddAsPrevious    (void const*, ICursorImpl&);

  void     AddAtPosition    (IPosition, void const*, ICursorImpl&);

  bool AllElementsDo    (IApplFunc, void*);

  void*    Any              () const;

  bool CheckCursor      (ICursorImpl const&) const;

  char const*
           ClassName        () const;

  IACollectionImpl*
           Clone            () const;

  bool Contains         (void const*) const;

  bool ContainsAllFrom  (IACollectionImpl const&) const;

  void     Copy             (IACollectionImpl const&);

  Cursor*  CreateCursor     () const;

  MngCursor*
           CreateMngCursor  () const;

  void*    ElementAt        (ICursorImpl const&) const;

  void*    ElementAtPosition
                            (IPosition) const;

  void*    First            () const;

  bool IsBounded        () const;

  bool IsConsistent     () const;

  bool IsEmpty          () const;

  bool IsFirstAt        (ICursorImpl const&) const;

  bool IsFull           () const;

  bool IsLastAt         (ICursorImpl const&) const;

  void*    Last             () const;

  bool Locate           (void const*, ICursorImpl&) const;

  bool LocateFirst      (void const*, ICursorImpl&) const;

  bool LocateLast       (void const*, ICursorImpl&) const;

  bool LocateNext       (void const*, ICursorImpl&) const;

  bool LocateOrAdd      (void const*, ICursorImpl&);

  bool LocatePrevious   (void const*, ICursorImpl&) const;

  INumber  NumberOfElements () const;

  INumber  NumberOfOccurrences
                            (void const*) const;

  IPosition
           PositionAt       (ICursorImpl const&) const;

  bool Remove           (void const*);

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  INumber  RemoveAllOccurrences
                            (void const*);

  void     RemoveAt         (ICursorImpl&);

  void     RemoveAtPosition (IPosition);

  void     RemoveFirst      ();

  void     RemoveLast       ();

  void     ReplaceAt        (ICursorImpl const&, void const*);

  void     ReplaceAtPosition
                            (IPosition, void const*);

  void     Reverse          ();

  bool SetToFirst       (ICursorImpl&) const;

  bool SetToLast        (ICursorImpl&) const;

  bool SetToNext        (ICursorImpl&) const;

  void     SetToPosition    (IPosition, ICursorImpl&) const;

  bool SetToPrevious    (ICursorImpl&) const;

  void     Sort             (ICompFunc, void*);

  void     operator=        (IEqualitySequenceOnSequenceImpl
                              <Base> const&);

  bool operator==       (IAEqualitySequenceImpl const&) const;

protected:

  bool EqualElements    (void const*, void const*) const;

private:

  static
  char const*
           cvClassName;

  Base&    ivBase;

  void const*
           ivElement;





  struct Predicate {

    typedef  IEqualitySequenceOnSequenceImpl <Base> ES;

    static
    bool IsEqual          (void const*, void*);

  };





  static
  Base&    BaseOf           (IEqualitySequenceOnSequenceImpl
                              <Base> const&);

  static
  Ops&     OpsOf            (IEqualitySequenceOnSequenceImpl
                              <Base> const&);

  friend
  class    IEqualitySequenceOnSequenceMngCursorImpl <Base>;

  friend
  struct   Predicate;

#if ! defined (__INO_STREAMING__)
public:
  IStreamerPtr&
           StreamerOf       (IACollectionImpl const&);

  void     StreamIn         (IDataStream&);

  void     StreamOut        (IDataStream&) const;

  void     AdoptStreamer    (IACollectionStreamer*);
#endif























};

template <class Base>
class IC_EXPORTC IAEqualitySequenceOnSequenceOps {
public:

  virtual ~IAEqualitySequenceOnSequenceOps
                            ();

  virtual
  bool EqualElements    (void const*, void const*) const = 0;

  virtual
  IACollectionImpl*
           Clone            () const = 0;

  virtual  operator Base&   () = 0;

protected:

private:









};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iiesseq.inl>


#pragma info (restore)


#endif // _IIESSEQ_
