// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 53 1.6.1.4 source/core/collect/iieslst.h, collection, ioc.v400, 980918 
#ifndef _IIESLST_
#define _IIESLST_

#include <iiesseq.h>
#include <iiseqlst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef IEqualitySequenceOnSequenceImpl
         <ISequenceAsListImpl> IEqualitySequenceAsListImpl;

typedef IAEqualitySequenceOnSequenceOps
         <ISequenceAsListImpl> IAEqualitySequenceAsListOps;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps, class Implementation>
class IC_EXPORTC IEqualitySequenceAsListOps :
  public IAEqualitySequenceAsListOps {

  typedef  IEqualitySequenceAsListOps
            <Element, ElementOps, Implementation> Self;

  typedef  ISequenceAsListOps
            <Element, ElementOps, ISequenceAsListImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  void KeyType;

           IEqualitySequenceAsListOps
                           (INumber);

           IEqualitySequenceAsListOps
                           (INumber, void*);

           IEqualitySequenceAsListOps
                           (IEqualitySequenceAsListOps
                             <Element, ElementOps,
                              Implementation> const&);

          ~IEqualitySequenceAsListOps
                           ();

  IACollectionImpl*
           Clone           () const;

  bool     EqualElements   (void const*, void const*) const;

           operator ISequenceAsListImpl&
                           ();

           operator Implementation*
                           ();


















protected:

private:

  ElementOps
           ivElementOps;

  Base     ivBase;

  Implementation
           ivImpl;












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#if ! defined (__TEMPINC__)
#include <iieslst.c>
#endif



#pragma info (restore)


#endif // _IIESLST_
