// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 50 1.6.1.4 source/core/collect/iiesdil.h, collection, ioc.v400, 980918 
#ifndef _IIESDIL_
#define _IIESDIL_

#include <iiesseq.h>
#include <iiseqdil.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef IEqualitySequenceOnSequenceImpl
         <ISequenceAsDilTableImpl> IEqualitySequenceAsDilTableImpl;

typedef IAEqualitySequenceOnSequenceOps
         <ISequenceAsDilTableImpl> IAEqualitySequenceAsDilTableOps;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps, class Implementation>
class IC_EXPORTC IEqualitySequenceAsDilTableOps :
  public IAEqualitySequenceAsDilTableOps {

  typedef  IEqualitySequenceAsDilTableOps
            <Element, ElementOps, Implementation> Self;

  typedef  ISequenceAsDilTableOps
            <Element, ElementOps, ISequenceAsDilTableImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  void KeyType;

           IEqualitySequenceAsDilTableOps
                           (INumber);

           IEqualitySequenceAsDilTableOps
                           (INumber, void*);

           IEqualitySequenceAsDilTableOps
                           (IEqualitySequenceAsDilTableOps
                             <Element, ElementOps,
                              Implementation> const&);

          ~IEqualitySequenceAsDilTableOps
                           ();

  IACollectionImpl*
           Clone           () const;

  bool     EqualElements   (void const*, void const*) const;

           operator ISequenceAsDilTableImpl&
                           ();

           operator Implementation*
                           ();


















protected:

private:

  ElementOps
           ivElementOps;

  Base     ivBase;

  Implementation
           ivImpl;












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#if ! defined (__TEMPINC__)
#include <iiesdil.c>
#endif



#pragma info (restore)


#endif // _IIESDIL_
