// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 47 1.6.1.4 source/core/collect/iicss.h, collection, ioc.v400, 980918 
#ifndef _IICSS_
#define _IICSS_

#include <ilanglvl.hpp>
#include <iiass.h>










#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)


#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template <class CInherited>
class ICSortedSetImpl : public CInherited {
public:

  typedef TYPENAME CInherited::Ops Ops;

           ICSortedSetImpl
                            (Ops&, INumber);

           ICSortedSetImpl
                            (Ops&, ICSortedSetImpl
                                    <CInherited> const&);

  bool     Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  void*    Any              () const;

  void*    ElementAt        (ICursorImpl const&) const;

  void*    ElementAtPosition
                            (IPosition) const;

  void*    First            () const;

  bool     IsFirstAt        (ICursorImpl const&) const;

  bool     IsLastAt         (ICursorImpl const&) const;

  void*    Last             () const;

  bool     Locate           (void const*, ICursorImpl&) const;

  bool     LocateNext       (void const*, ICursorImpl&) const;

  bool     LocateOrAdd      (void const*, ICursorImpl&);

  IPosition
           PositionAt       (ICursorImpl const&) const;

  void     RemoveAt         (ICursorImpl&);

  void     RemoveAtPosition (IPosition);

  void     RemoveFirst      ();

  void     RemoveLast       ();

  void     ReplaceAt        (ICursorImpl const& cursor,
                             void const*);

  void     ReplaceAtPosition
                            (IPosition, void const*);

  bool     SetToFirst       (ICursorImpl&) const;

  bool     SetToLast        (ICursorImpl&) const;

  bool     SetToNext        (ICursorImpl&) const;

  void     SetToPosition    (IPosition, ICursorImpl&) const;

  bool     SetToPrevious    (ICursorImpl&) const;

protected:

private:












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#if ! defined (__TEMPINC__)
#include <iicss.c>
#endif



#pragma info (restore)


#endif // _IICSS_
