// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 41 1.6.1.4 source/core/collect/iicset.h, collection, ioc.v400, 980918 
#ifndef _IICSET_
#define _IICSET_

#include <ilanglvl.hpp>
#include <iiaset.h>










#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)


#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template <class CInherited>
class ICSetImpl : public CInherited {
public:

  typedef TYPENAME CInherited::Ops Ops;

           ICSetImpl
                            (Ops&, INumber);

           ICSetImpl
                            (Ops&, ICSetImpl
                                    <CInherited> const&);

  bool     Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  void*    Any              () const;

  void*    ElementAt        (ICursorImpl const&) const;

  bool     Locate           (void const*, ICursorImpl&) const;

  bool     LocateNext       (void const*, ICursorImpl&) const;

  bool     LocateOrAdd      (void const*, ICursorImpl&);

  void     RemoveAt         (ICursorImpl&);

  void     ReplaceAt        (ICursorImpl const& cursor,
                             void const*);

  bool     SetToFirst       (ICursorImpl&) const;

  bool     SetToNext        (ICursorImpl&) const;

protected:

private:












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#if ! defined (__TEMPINC__)
#include <iicset.c>
#endif



#pragma info (restore)


#endif // _IICSET_
