// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 39 1.6.1.4 source/core/collect/iicseq.h, collection, ioc.v400, 980918 
#ifndef _IICSEQ_
#define _IICSEQ_

#include <ilanglvl.hpp>
#include <iiaseq.h>










#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)


#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template <class CInherited>
class ICSequenceImpl : public CInherited {
public:

  typedef TYPENAME CInherited::Ops Ops;

           ICSequenceImpl
                            (Ops&, INumber);

           ICSequenceImpl
                            (Ops&, ICSequenceImpl
                                    <CInherited> const&);

  bool     Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  void     AddAsFirst       (void const*, ICursorImpl&);

  void     AddAsLast        (void const*, ICursorImpl&);

  void     AddAsNext        (void const*, ICursorImpl&);

  void     AddAsPrevious    (void const*, ICursorImpl&);

  void     AddAtPosition    (IPosition, void const*, ICursorImpl&);

  void*    Any              () const;

  void*    ElementAt        (ICursorImpl const&) const;

  void*    ElementAtPosition
                            (IPosition) const;

  void*    First            () const;

  bool     IsFirstAt        (ICursorImpl const&) const;

  bool     IsLastAt         (ICursorImpl const&) const;

  void*    Last             () const;

  IPosition
           PositionAt       (ICursorImpl const&) const;

  void     RemoveAt         (ICursorImpl&);

  void     RemoveAtPosition (IPosition);

  void     RemoveFirst      ();

  void     RemoveLast       ();

  void     ReplaceAt        (ICursorImpl const& cursor,
                             void const*);

  void     ReplaceAtPosition
                            (IPosition, void const*);

  bool     SetToFirst       (ICursorImpl&) const;

  bool     SetToLast        (ICursorImpl&) const;

  bool     SetToNext        (ICursorImpl&) const;

  void     SetToPosition    (IPosition, ICursorImpl&) const;

  bool     SetToPrevious    (ICursorImpl&) const;

protected:

private:












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#if ! defined (__TEMPINC__)
#include <iicseq.c>
#endif



#pragma info (restore)


#endif // _IICSEQ_
