// Revision: 86 1.5.1.6 source/ui/basectl/iiconctl.hpp, staticctls, ioc.v400, 980918 
#ifndef _IICONCTL_
  #define _IICONCTL_
/*******************************************************************************
* FILE NAME: iiconctl.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*    IIconControl                                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <ibmpctl.hpp>
#include <irect.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IPointerHandle;
class IResourceId;
class ISize;
class IWindowHandle;
class IIconControlData;

#pragma enum(4)
#pragma pack(push,4)

class IIconControl : public IBitmapControl  {
typedef IBitmapControl
  Inherited;
public:
class Style;
/*------------------------ Constructors --------------------------------------*/
  IIconControl(unsigned long id,
               IWindow* parent,
               IWindow* owner,
               const IResourceId& iconId,
               const IRectangle& initial= IRectangle(),
               const Style& style = defaultStyle() );

  IIconControl(unsigned long id,
               IWindow* parent,
               IWindow* owner,
               unsigned long iconId,
               const IRectangle& initial= IRectangle(),
               const Style& style = defaultStyle() );

  IIconControl(unsigned long id,
               IWindow* parent,
               IWindow* owner,
               const IPointerHandle& iconId = IPointerHandle(),
               const IRectangle& initial= IRectangle(),
               const Style& style = defaultStyle() );

  IIconControl(unsigned long id,
               IWindow* parent,
               IWindow* owner,
               ISystemPointerHandle::EPointerType icon,
               const IRectangle& initial= IRectangle(),
               const Style& style = defaultStyle() );

  IIconControl(unsigned long id,
               IWindow* parentDialog);

  IIconControl(const IWindowHandle& handle);

virtual
  ~IIconControl();

/*---------------------------------- Styles  ---------------------------------*/
INESTEDBITFLAGCLASSDEF3(Style, IIconControl, IWindow, IControl, IStaticText);
                               // style class definition

static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU sizeImageToWindow,
  IC_IMPORTU sizeWindowToImage;

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      bool         extendedOnly = false ) const;

/*------------------------------- Icons --------------------------------------*/
virtual IIconControl
  &setIcon(unsigned long iconId),
  &setIcon(const IResourceId&  iconId),
  &setIcon(const IPointerHandle& handle);

virtual IIconControl
  &setIcon(ISystemPointerHandle::Identifier icon);

IPointerHandle
  icon() const;

/*---------------------------- Canvas Support --------------------------------*/
virtual IRectangle
  visibleRectangle   ( ) const;

protected:
/*----------------------------- Layout Support -------------------------------*/
virtual ISize
  calcMinimumSize() const;

private:
/*--------------------------------- Private ----------------------------------*/

static Style
  currentDefaultStyle;

IIconControlData
 *fIconControlData;

IPointerHandle
  iconHandle;
bool
  returnback;

IIconControl
  &initialize(const Style& style);

/*----------------------------- Hidden Functions -----------------------------*/
  IIconControl(const IIconControl&);
  IIconControl& operator=(const IIconControl&);

public:
#if (IC_OBSOLETE <= IC_OBSOLETE_3)
static const Style
  IC_IMPORTU sizeToIcon;

  IIconControl(unsigned long id,
               IWindow* parent,
               IWindow* owner,
               ISystemPointerHandle::Identifier icon,
               const IRectangle& initial= IRectangle(),
               const Style& style = defaultStyle() );
#endif // IC_OBSOLETE

};  // class IIconControl

INESTEDBITFLAGCLASSFUNCS(Style, IIconControl)
                                  // global style functions

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif  /* _IICONCTL_ */
