// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 33 1.5.1.3 source/core/collect/iicmwt.h, collection, ioc.v400, 980918 
#ifndef _IICMWT_
#define _IICMWT_

#include <ilanglvl.hpp>
#include <iimwt.h>










#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)


#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template <class CInherited>
class IC_EXPORTC ICMultiwayTreeImpl : public CInherited 
{
public:

  typedef TYPENAME CInherited::Ops Ops;

           ICMultiwayTreeImpl
                            (Ops&);

           ICMultiwayTreeImpl
                            (Ops&,
                             ICMultiwayTreeImpl <CInherited> const&);

  void     AddAsChild       (ITreeCursorImpl const&,
                             IPosition, void const*);

  void     AddAsRoot        (void const*);

  bool AllSubtreeElementsDo
                            (ITreeCursorImpl const&, IApplFunc,
                             ITreeIterationOrder, void*);

  void     AttachAsChild    (ITreeCursorImpl const&,
                             IPosition, IMultiwayTreeImpl&);

  void     AttachAsRoot     (IMultiwayTreeImpl&);

  void     AttachSubtreeAsChild
                            (ITreeCursorImpl const&, IPosition,
                             IMultiwayTreeImpl&,
                             ITreeCursorImpl const&);

  void     AttachSubtreeAsRoot
                            (IMultiwayTreeImpl&,
                             ITreeCursorImpl const&);

  IPosition
           ChildPositionAt  (ITreeCursorImpl const&) const;
  
  void     CopySubtree      (IMultiwayTreeImpl const&,
                             ITreeCursorImpl const&);

  void*    ElementAt        (ITreeCursorImpl const&) const;

  bool HasChild         (IPosition, ITreeCursorImpl const&) const;

  bool IsLeaf           (ITreeCursorImpl const&) const;

  bool IsRoot           (ITreeCursorImpl const&) const;

  INumber  NumberOfSubtreeElements
                            (ITreeCursorImpl const&) const;


  INumber  NumberOfSubtreeLeaves
                            (ITreeCursorImpl const&) const;

  INumber  RemoveSubtree    (ITreeCursorImpl&);

  void     ReplaceAt        (ITreeCursorImpl const& cursor,
                             void const*);

  bool SetToChild       (IPosition, ITreeCursorImpl&) const;

  bool SetToFirst       (ITreeCursorImpl&,
                             ITreeIterationOrder) const;

  bool SetToFirstExistingChild
                            (ITreeCursorImpl&) const;

  bool SetToLast        (ITreeCursorImpl&,
                             ITreeIterationOrder) const;

  bool SetToLastExistingChild
                            (ITreeCursorImpl&) const;

  bool SetToNext        (ITreeCursorImpl&,
                             ITreeIterationOrder) const;

  bool SetToNextExistingChild
                            (ITreeCursorImpl&) const;

  bool SetToParent      (ITreeCursorImpl&) const;

  bool SetToPrevious    (ITreeCursorImpl&,
                             ITreeIterationOrder) const;

  bool SetToPreviousExistingChild
                            (ITreeCursorImpl&) const;

  bool SetToRoot        (ITreeCursorImpl&) const;

protected:

private:












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#if ! defined (__TEMPINC__)
#include <iicmwt.c>
#endif



#pragma info (restore)


#endif // _IICMWT_
