// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 31 1.6.1.4 source/core/collect/iicmap.h, collection, ioc.v400, 980918 
#ifndef _IICMAP_
#define _IICMAP_

#include <ilanglvl.hpp>
#include <iiamap.h>










#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)


#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template <class CInherited>
class ICMapImpl : public CInherited {
public:

  typedef TYPENAME CInherited::Ops Ops;

           ICMapImpl
                            (Ops&, INumber);

           ICMapImpl
                            (Ops&, ICMapImpl
                                    <CInherited> const&);

  bool     Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  bool     AddOrReplaceElementWithKey
                            (void const*, ICursorImpl&);

  void*    Any              () const;

  void*    ElementAt        (ICursorImpl const&) const;

  void*    ElementWithKey   (void const*) const;

  bool     Locate           (void const*, ICursorImpl&) const;

  bool     LocateElementWithKey
                            (void const*, ICursorImpl&) const;

  bool     LocateNext       (void const*, ICursorImpl&) const;

  bool     LocateNextElementWithKey
                            (void const*, ICursorImpl&) const;

  bool     LocateOrAdd      (void const*, ICursorImpl&);

  bool     LocateOrAddElementWithKey
                            (void const*, ICursorImpl&);

  void     RemoveAt         (ICursorImpl&);

  void     ReplaceAt        (ICursorImpl const& cursor,
                             void const*);

  bool     ReplaceElementWithKey
                            (void const*, ICursorImpl&);

  bool     SetToFirst       (ICursorImpl&) const;

  bool     SetToNext        (ICursorImpl&) const;

  bool     SetToNextWithDifferentKey
                            (ICursorImpl&) const;

protected:

private:












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#if ! defined (__TEMPINC__)
#include <iicmap.c>
#endif



#pragma info (restore)


#endif // _IICMAP_
