// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 29 1.6.1.4 source/core/collect/iickss.h, collection, ioc.v400, 980918 
#ifndef _IICKSS_
#define _IICKSS_

#include <ilanglvl.hpp>
#include <iiakss.h>










#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)


#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template <class CInherited>
class ICKeySortedSetImpl : public CInherited {
public:

  typedef TYPENAME CInherited::Ops Ops;

           ICKeySortedSetImpl
                            (Ops&, INumber);

           ICKeySortedSetImpl
                            (Ops&, ICKeySortedSetImpl
                                    <CInherited> const&);

  bool     Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  bool     AddOrReplaceElementWithKey
                            (void const*, ICursorImpl&);

  void*    Any              () const;

  void*    ElementAt        (ICursorImpl const&) const;

  void*    ElementAtPosition
                            (IPosition) const;

  void*    ElementWithKey   (void const*) const;

  void*    First            () const;

  bool     IsFirstAt        (ICursorImpl const&) const;

  bool     IsLastAt         (ICursorImpl const&) const;

  void*    Last             () const;

  bool     LocateElementWithKey
                            (void const*, ICursorImpl&) const;

  bool     LocateNextElementWithKey
                            (void const*, ICursorImpl&) const;

  bool     LocateOrAddElementWithKey
                            (void const*, ICursorImpl&);

  IPosition
           PositionAt       (ICursorImpl const&) const;

  void     RemoveAt         (ICursorImpl&);

  void     RemoveAtPosition (IPosition);

  void     RemoveFirst      ();

  void     RemoveLast       ();

  void     ReplaceAt        (ICursorImpl const& cursor,
                             void const*);

  void     ReplaceAtPosition
                            (IPosition, void const*);

  bool     ReplaceElementWithKey
                            (void const*, ICursorImpl&);

  bool     SetToFirst       (ICursorImpl&) const;

  bool     SetToLast        (ICursorImpl&) const;

  bool     SetToNext        (ICursorImpl&) const;

  bool     SetToNextWithDifferentKey
                            (ICursorImpl&) const;

  void     SetToPosition    (IPosition, ICursorImpl&) const;

  bool     SetToPrevious    (ICursorImpl&) const;

protected:

private:












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#if ! defined (__TEMPINC__)
#include <iickss.c>
#endif



#pragma info (restore)


#endif // _IICKSS_
