// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 21 1.6.1.4 source/core/collect/iichp.h, collection, ioc.v400, 980918 
#ifndef _IICHP_
#define _IICHP_

#include <ilanglvl.hpp>
#include <iiahp.h>










#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)


#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template <class CInherited>
class ICHeapImpl : public CInherited {
public:

  typedef TYPENAME CInherited::Ops Ops;

           ICHeapImpl
                            (Ops&, INumber);

           ICHeapImpl
                            (Ops&, ICHeapImpl
                                    <CInherited> const&);

  bool     Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  void*    Any              () const;

  void*    ElementAt        (ICursorImpl const&) const;

  void     RemoveAt         (ICursorImpl&);

  void     ReplaceAt        (ICursorImpl const& cursor,
                             void const*);

  bool     SetToFirst       (ICursorImpl&) const;

  bool     SetToNext        (ICursorImpl&) const;

protected:

private:












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#if ! defined (__TEMPINC__)
#include <iichp.c>
#endif



#pragma info (restore)


#endif // _IICHP_
