// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 12 1.6.1.4 source/core/collect/iibaglst.h, collection, ioc.v400, 980918 
#ifndef _IIBAGLST_
#define _IIBAGLST_

#include <iibagkb.h>
#include <iikblst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef IBagOnKeyBagImpl
         <IKeyBagAsListImpl> IBagAsListImpl;

typedef IABagOnKeyBagOps
         <IKeyBagAsListImpl> IABagAsListOps;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps, class Implementation>
class IC_EXPORTC IBagAsListOps :
  public IABagAsListOps {

  typedef  IABagAsListOps Inherited;

  typedef  IBagAsListOps
            <Element, ElementOps, Implementation> Self;

  typedef  IKeyBagAsListOps
            <Element, Element, IOpsWithKey <Element, ElementOps>,
             IKeyBagAsListImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  void KeyType;

           IBagAsListOps
                           (INumber);

           IBagAsListOps
                           (INumber, void*);

           IBagAsListOps
                           (IBagAsListOps
                             <Element, ElementOps,
                              Implementation> const&);

          ~IBagAsListOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator IKeyBagAsListImpl&
                           ();

           operator Implementation*
                           ();


















protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#if ! defined (__TEMPINC__)
#include <iibaglst.c>
#endif



#pragma info (restore)


#endif // _IIBAGLST_
