// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 08 1.6.1.3 source/core/collect/iibagkb.h, collection, ioc.v400, 980918 
#ifndef _IIBAGKB_
#define _IIBAGKB_

#include <ilanglvl.hpp>
#include <iiabag.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Base>
class IBagOnKeyBagMngCursorImpl;

template <class Base>
class IBagOnKeyBagImpl;

#pragma pack(push,4)
#pragma enum(4)

template <class Base>
class IC_EXPORTC IBagOnKeyBagMngCursorImpl : public Base::MngCursor 
{

  typedef TYPENAME Base::MngCursor Inherited;

public:

           IBagOnKeyBagMngCursorImpl
                            (IBagOnKeyBagImpl <Base> const&);


          ~IBagOnKeyBagMngCursorImpl
                             ();

protected:

private:









};

template <class Base>
class IABagOnKeyBagOps;

template <class Base>
class IC_EXPORTC IBagOnKeyBagImpl : public IABagImpl {

  typedef  IABagImpl Inherited;

  typedef  IBagOnKeyBagImpl <Base> Self;

public:

  typedef  IABagOnKeyBagOps <Base> Ops;

  typedef TYPENAME Base::Cursor Cursor;

  typedef  IBagOnKeyBagMngCursorImpl <Base> MngCursor;

           IBagOnKeyBagImpl (Ops&, INumber);

           IBagOnKeyBagImpl (Ops&, IBagOnKeyBagImpl <Base> const&);

          ~IBagOnKeyBagImpl ();

  bool Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  bool AllElementsDo    (IApplFunc, void*);

  void*    Any              () const;

  bool CheckCursor      (ICursorImpl const&) const;

  bool CheckReplacement (ICursorImpl const&, void const*) const;

  char const*
           ClassName        () const;

  IACollectionImpl*
           Clone            () const;

  bool Contains         (void const*) const;

  bool ContainsAllFrom  (IACollectionImpl const&) const;

  void     Copy             (IACollectionImpl const&);

  Cursor*  CreateCursor     () const;

  MngCursor*
           CreateMngCursor  () const;

  void*    ElementAt        (ICursorImpl const&) const;

  bool IsBounded        () const;

  bool IsConsistent     () const;

  bool IsEmpty          () const;

  bool IsFull           () const;

  bool Locate           (void const*, ICursorImpl&) const;

  bool LocateNext       (void const*, ICursorImpl&) const;

  bool LocateOrAdd      (void const*, ICursorImpl&);

  INumber  NumberOfDifferentElements
                            () const;

  INumber  NumberOfElements () const;

  INumber  NumberOfOccurrences
                            (void const*) const;

  bool Remove           (void const*);

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  INumber  RemoveAllOccurrences
                            (void const*);

  void     RemoveAt         (ICursorImpl&);

  void     ReplaceAt        (ICursorImpl const&, void const*);

  bool SetToFirst       (ICursorImpl&) const;

  bool SetToNext        (ICursorImpl&) const;

  bool SetToNextDifferentElement
                            (ICursorImpl&) const;

  void     operator=        (IBagOnKeyBagImpl <Base> const&);

  bool operator==       (IABagImpl const&) const;

protected:

private:

  static
  char const*
           cvClassName;

  Base&    ivBase;

  static
  Base&    BaseOf           (IBagOnKeyBagImpl <Base> const&);

  static
  Ops&     OpsOf            (IBagOnKeyBagImpl <Base> const&);

  friend
  class    IBagOnKeyBagMngCursorImpl <Base>;

#if ! defined (__INO_STREAMING__)
public:
  IStreamerPtr&
           StreamerOf       (IACollectionImpl const&);

  void     StreamIn         (IDataStream&);

  void     StreamOut        (IDataStream&) const;

  void     AdoptStreamer    (IACollectionStreamer*);
#endif

















};

template <class Base>
class IC_EXPORTC IABagOnKeyBagOps {
public:

  virtual ~IABagOnKeyBagOps ();

  virtual
  IACollectionImpl*
           Clone            () const = 0;

  virtual  operator Base&   () = 0;

protected:

  // for backward compatibility
           IABagOnKeyBagOps (bool);

private:









};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iibagkb.inl>


#pragma info (restore)


#endif // _IIBAGKB_
