// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 06 1.6.1.3 source/core/collect/iibaghsh.h, collection, ioc.v400, 980918 
#ifndef _IIBAGHSH_
#define _IIBAGHSH_

#include <iibagkb.h>
#include <iikbhsh.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef IBagOnKeyBagImpl
         <IKeyBagAsHshTableImpl> IBagAsHshTableImpl;

typedef IABagOnKeyBagOps
         <IKeyBagAsHshTableImpl> IABagAsHshTableOps;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps, class Implementation>
class IC_EXPORTC IBagAsHshTableOps :
  public IABagAsHshTableOps {

  typedef  IABagAsHshTableOps Inherited;

  typedef  IBagAsHshTableOps
            <Element, ElementOps, Implementation> Self;

  typedef  IKeyBagAsHshTableOps
            <Element, Element, IOpsWithKey <Element, ElementOps>,
             IKeyBagAsHshTableImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  void KeyType;

           IBagAsHshTableOps
                           (INumber);

           IBagAsHshTableOps
                           (INumber, void*);

           IBagAsHshTableOps
                           (IBagAsHshTableOps
                             <Element, ElementOps,
                              Implementation> const&);

          ~IBagAsHshTableOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator IKeyBagAsHshTableImpl&
                           ();

           operator Implementation*
                           ();


















protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#include <iibaghsh.c>



#pragma info (restore)


#endif // _IIBAGHSH_
