// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 99 1.7.1.3 source/core/collect/iiatree.h, collection, ioc.v400, 980918 
#ifndef _IIATREE_
#define _IIATREE_

#include <iiglobal.h>
#include <iexctxt.h>


#include <ireslock.hpp>








#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)











#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IATreeImpl;

#pragma pack(push,4)
#pragma enum(4)

enum ITreeIterationOrder 
{
  IPreorder,
  IPostorder
};


class IC_EXPORTC ITreeResourceImpl 
{
public:
                 ITreeResourceImpl ();

                 ~ITreeResourceImpl();

        void     lock              (long);

        void     unlock            ();

protected:
        IResource* ivResource;

private:












};


class IC_EXPORTC ITreeCursorImpl 
{
public:

           ITreeCursorImpl  (IATreeImpl const&);

  virtual ~ITreeCursorImpl  ();

  virtual
  ITreeCursorImpl*
           Clone            () const = 0;

  virtual
  void     Copy             (ITreeCursorImpl const&) = 0;

  void const*
           Element          () const;

  virtual
  void     Invalidate       () = 0;

  bool IsFor            (IATreeImpl const&) const;

  virtual
  bool IsValid          () const = 0;

  bool SetToChild       (IPosition);

  bool SetToFirstExistingChild
                            ();

  bool SetToLastExistingChild
                            ();

  bool SetToNextExistingChild
                            ();

  bool SetToParent      ();

  bool SetToPreviousExistingChild
                            ();

  bool SetToRoot        ();

  void     operator=        (ITreeCursorImpl const&);

  virtual
  bool operator==       (ITreeCursorImpl const&) const = 0;

  bool operator!=       (ITreeCursorImpl const&) const;

protected:

  IATreeImpl const*
           ivTree;

  static
  void*    CheckPointer     (void*);

private:






























};

class IATreeOps;

class IC_EXPORTC IATreeImpl 
{
public :

  typedef  IATreeOps Ops;

          ~IATreeImpl       ();

  virtual
  void     AddAsChild       (ITreeCursorImpl const&,
                             IPosition, void const*) = 0;

  virtual
  void     AddAsRoot        (void const*) = 0;

  virtual
  bool AllElementsDo    (IApplFunc, ITreeIterationOrder, void*) = 0;

  virtual
  bool AllSubtreeElementsDo
                            (ITreeCursorImpl const&, IApplFunc,
                             ITreeIterationOrder, void*) = 0;

  static
  void*    CheckPointer     (void*);

  virtual
  INumber  ChildPositionAt  (ITreeCursorImpl const&) const = 0;

  virtual
  char const*
           ClassName        () const = 0;

  virtual
  IATreeImpl*
           Clone            () const = 0;

  virtual
  ITreeCursorImpl*
           CreateCursor     () const = 0;

  void     Delete           ();

  virtual
  void*    ElementAt        (ITreeCursorImpl const&) const = 0;

  void     Initialize       ();

  virtual
  bool IsConsistent     () const = 0;

  virtual
  bool IsEmpty          () const;

  virtual
  bool IsLeaf           (ITreeCursorImpl const&) const = 0;

  virtual
  bool IsRoot           (ITreeCursorImpl const&) const = 0;

  void     LockBeforeReading
                            (long = -1);

  void     LockBeforeWriting
                            (long = -1);

  virtual
  INumber  NumberOfElements () const = 0;

  virtual
  INumber  NumberOfLeaves   () const = 0;

  virtual
  INumber  NumberOfSubtreeElements
                            (ITreeCursorImpl const&) const = 0;

  virtual
  INumber  NumberOfSubtreeLeaves
                            (ITreeCursorImpl const&) const = 0;

        virtual
        void     Release          () const;

  virtual
  INumber  RemoveAll        () = 0;

  virtual
  INumber  RemoveSubtree    (ITreeCursorImpl&) = 0;

  virtual
  void     ReplaceAt        (ITreeCursorImpl const&, void const*) = 0;

        virtual
        void     Seize            (long timeout = -1);

  virtual
  bool SetToChild       (IPosition, ITreeCursorImpl&) const = 0;

  virtual
  bool SetToFirst       (ITreeCursorImpl&,
                             ITreeIterationOrder) const = 0;

  virtual
  bool SetToFirstExistingChild
                            (ITreeCursorImpl&) const = 0;

  virtual
  bool SetToLast        (ITreeCursorImpl&,
                             ITreeIterationOrder) const = 0;

  virtual
  bool SetToLastExistingChild
                            (ITreeCursorImpl&) const = 0;

  virtual
  bool SetToNext        (ITreeCursorImpl&,
                             ITreeIterationOrder) const = 0;

  virtual
  bool SetToNextExistingChild
                            (ITreeCursorImpl&) const = 0;

  virtual
  bool SetToParent      (ITreeCursorImpl&) const = 0;

  virtual
  bool SetToPrevious    (ITreeCursorImpl&,
                             ITreeIterationOrder) const = 0;

  virtual
  bool SetToPreviousExistingChild
                            (ITreeCursorImpl&) const = 0;

  virtual
  bool SetToRoot        (ITreeCursorImpl&) const = 0;

  void     UnlockAfterReading
                            ();

  void     UnlockAfterWriting
                            ();

protected:

           IATreeImpl       (Ops&);

           IATreeImpl       (IATreeImpl const&);

  static
  Ops&     OpsOf            (IATreeImpl const&);

private:

  Ops*     ivOps;

  INumber  ivReferenceCount;


  ITreeResourceImpl*
           ivResource;


#if ! defined (__INO_STREAMING__)
protected:
  IStreamerPtr
           ivStreamer;

public:
  virtual
  void     StreamIn         (IDataStream&) = 0;

  virtual
  void     StreamOut        (IDataStream&) const = 0;

  virtual
  void     AdoptStreamer    (IACollectionStreamer*) = 0;

  virtual
  void     WriteVersion     (IDataStream&) const;

  virtual
  void     ReadVersion      (IDataStream&);
#endif








































































};

class IC_EXPORTC IATreeOps 
{
public:

  virtual ~IATreeOps        ();

protected:

private:







};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif






#pragma info (restore)


#include <iiatree.inl>

#endif // _IIATREE_
