// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 93 1.5.1.3 source/core/collect/iiasm.h, collection, ioc.v400, 980918 
#ifndef _IIASM_
#define _IIASM_

#include <iiacllct.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

class IC_EXPORTC IASortedMapImpl : public IACollectionImpl {
public:

          ~IASortedMapImpl
                            ();

  virtual
  void     Antivalence      (IASortedMapImpl const&);

  virtual
  void     AddAntivalence   (IASortedMapImpl const&,
                             IASortedMapImpl const&); 

  virtual
  void     AddDifference    (IASortedMapImpl const&,
                             IASortedMapImpl const&); 

  virtual
  void     AddIntersection  (IASortedMapImpl const&,
                             IASortedMapImpl const&);

  virtual
  void     AddUnion         (IASortedMapImpl const&,
                             IASortedMapImpl const&);

  virtual
  long     Compare          (IASortedMapImpl const&,
                             ICompFunc, void*) const;

  virtual
  void     Difference       (IASortedMapImpl const&);

  virtual
  void     Intersection     (IASortedMapImpl const&);

  virtual
  void     Union            (IASortedMapImpl const&);

  virtual
  bool     operator==       (IASortedMapImpl const&) const = 0;

  bool     operator!=       (IASortedMapImpl const&) const;

protected:

           IASortedMapImpl
                            (Ops&);

  INumber  NumberOfDifferentKeys
                            () const;

  INumber  NumberOfElementsWithKey
                            (void const*) const;

  INumber  NumberOfOccurrences
                            (void const*) const;

  INumber  RemoveAllOccurrences
                            (void const*);

  INumber  RemoveAllElementsWithKey
                            (void const*);

  bool     SetToNextWithDifferentKey
                            (ICursorImpl&) const;

private:

























};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif






#pragma info (restore)


#endif // _IIASM_
