// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 83 1.5.1.3 source/core/collect/iiamap.h, collection, ioc.v400, 980918 
#ifndef _IIAMAP_
#define _IIAMAP_

#include <iiacllct.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

class IC_EXPORTC IAMapImpl : public IACollectionImpl {
public:

          ~IAMapImpl
                            ();

  virtual
  void     Antivalence      (IAMapImpl const&);

  virtual
  void     AddAntivalence   (IAMapImpl const&,
                             IAMapImpl const&); 

  virtual
  void     AddDifference    (IAMapImpl const&,
                             IAMapImpl const&); 

  virtual
  void     AddIntersection  (IAMapImpl const&,
                             IAMapImpl const&);

  virtual
  void     AddUnion         (IAMapImpl const&,
                             IAMapImpl const&);

  virtual
  void     Difference       (IAMapImpl const&);

  virtual
  void     Intersection     (IAMapImpl const&);

  virtual
  void     Union            (IAMapImpl const&);

  virtual
  bool     operator==       (IAMapImpl const&) const = 0;

  bool     operator!=       (IAMapImpl const&) const;

protected:

           IAMapImpl
                            (Ops&);

  bool     LocateNext       (void const*, ICursorImpl&) const;

  bool     LocateNextElementWithKey
                            (void const*, ICursorImpl&) const;

  INumber  NumberOfDifferentKeys
                            () const;

  INumber  NumberOfElementsWithKey
                            (void const*) const;

  INumber  NumberOfOccurrences
                            (void const*) const;

  INumber  RemoveAllOccurrences
                            (void const*);

  INumber  RemoveAllElementsWithKey
                            (void const*);

  bool     SetToNextWithDifferentKey
                            (ICursorImpl&) const;

private:























};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif






#pragma info (restore)


#endif // _IIAMAP_
