// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 68 1.7.1.3 source/core/collect/iiacllct.h, collection, ioc.v400, 980918 
#ifndef _IIACLLCT_
#define _IIACLLCT_

#include <iiglobal.h>
#include <iexctxt.h>


#include <ireslock.hpp>



#include <iivcllct.h>



#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IACollectionImpl;

#pragma pack(push,4)
#pragma enum(4)


class IC_EXPORTC ICollectionResourceImpl 
{
public:
           ICollectionResourceImpl
                            ();

           ~ICollectionResourceImpl
                            ();

  void     lock             (long);

  void     unlock           ();

protected:
  IResource* ivResource;

private:










};


class IC_EXPORTC ICursorImpl {
public:

           ICursorImpl      (IACollectionImpl const&);

  virtual ~ICursorImpl      ();

  virtual
  ICursorImpl*
           Clone            () const = 0;

  virtual
  void     Copy             (ICursorImpl const&) = 0;

  void const*
           Element          () const;

  virtual
  void     Invalidate       () = 0;

  bool IsFor            (IACollectionImpl const&) const;

  virtual
  bool IsInBetween      () const = 0;

  virtual
  bool IsMngCursor      () const;

  virtual
  bool IsValid          () const = 0;

  IPosition
           Position         () const;

  bool SetToFirst       ();

  bool SetToLast        ();

  bool SetToNext        ();

  void     SetToPosition    (IPosition);

  bool SetToPrevious    ();

  virtual
  bool operator==       (ICursorImpl const&) const;

  bool operator!=       (ICursorImpl const&) const;

protected:

  IACollectionImpl const*
           ivCollection;

  static
  void*    CheckPointer     (void*);

private:



























};






class IACollectionOps;


class IC_EXPORTC IACollectionImpl : public IVCollectionImpl 
{




public:

  typedef  IACollectionOps Ops;

          ~IACollectionImpl ();

  bool Add              (void const*);

  virtual
  bool Add              (void const*, ICursorImpl&) = 0;

  void     AddAsFirst       (void const*);

  virtual
  void     AddAsFirst       (void const*, ICursorImpl&); // = 0

  void     AddAsLast        (void const*);

  virtual
  void     AddAsLast        (void const*, ICursorImpl&); // = 0

  virtual
  void     AddAsNext        (void const*, ICursorImpl&); // = 0

  virtual
  void     AddAsPrevious    (void const*, ICursorImpl&); // = 0

  void     AddAtPosition    (IPosition, void const*);

  virtual
  void     AddAtPosition    (IPosition,
                             void const*, ICursorImpl&); // = 0

  bool AddOrReplaceElementWithKey
                            (void const*);

  virtual
  bool AddOrReplaceElementWithKey
                            (void const*, ICursorImpl&); // = 0

  virtual
  void     AddAllFrom       (IACollectionImpl const&);

  virtual
  bool AllElementsDo    (IApplFunc, void*);

  virtual
  void*    Any              () const = 0;

  static
  void*    CheckPointer     (void*);

  virtual
  char const*
           ClassName        () const = 0;

  virtual
  IACollectionImpl*
           Clone            () const = 0;

  virtual
  bool Contains         (void const*) const; // = 0

  virtual
  bool ContainsAllFrom  (IACollectionImpl const&) const; // = 0

  virtual
  bool ContainsAllKeysFrom
                            (IACollectionImpl const&) const; // = 0

  virtual
  bool ContainsElementWithKey
                            (void const*) const; // = 0

  virtual
  void     Copy             (IACollectionImpl const&);

  virtual
  ICursorImpl*
           CreateCursor     () const = 0;

  virtual
  ICursorImpl*
           CreateMngCursor  () const = 0;

  void     Delete           ();

  virtual
  void*    ElementAt        (ICursorImpl const&) const = 0;

  virtual
  void*    ElementAtPosition
                            (IPosition) const; // = 0

  virtual
  void*    ElementWithKey   (void const*) const; // = 0

  virtual
  void*    First            () const;

  void     Initialize       ();

  virtual
  bool IsBounded        () const = 0;

  virtual
  bool IsConsistent     () const = 0;

  virtual
  bool IsEmpty          () const;

  virtual
  bool IsFirstAt        (ICursorImpl const&) const;

  virtual
  bool IsFull           () const = 0;

  virtual
  bool IsLastAt         (ICursorImpl const&) const;

  virtual
  void*    Key              (void const*) const; // = 0

  virtual
  void*    Last             () const;

  virtual
  bool Locate           (void const*, ICursorImpl&) const; // = 0

  virtual
  bool LocateElementWithKey
                            (void const*, ICursorImpl&) const; // = 0

  virtual
  bool LocateNext       (void const*, ICursorImpl&) const; // = 0

  virtual
  bool LocateNextElementWithKey
                            (void const*, ICursorImpl&) const; // = 0

  bool LocateOrAdd      (void const*);

  virtual
  bool LocateOrAdd      (void const*, ICursorImpl&); // = 0

  bool LocateOrAddElementWithKey
                            (void const*);

  virtual
  bool LocateOrAddElementWithKey
                            (void const*, ICursorImpl&); // = 0

  virtual
  void     LockBeforeReading
                            (long = -1);

  virtual
  void     LockBeforeWriting
                            (long = -1);

  virtual
  INumber  MaxNumberOfElements
                            () const;

  virtual
  INumber  NumberOfDifferentKeys
                            () const; // = 0

  virtual
  INumber  NumberOfElements () const = 0;

  virtual
  INumber  NumberOfElementsWithKey
                            (void const*) const; // = 0

  virtual
  INumber  NumberOfOccurrences
                            (void const*) const; // = 0

  virtual
  IPosition
           PositionAt       (ICursorImpl const&) const; // = 0

  virtual
  void     Release          () const;

  virtual
  bool Remove           (void const*); // = 0

  virtual
  INumber  RemoveAll        () = 0;

  virtual
  INumber  RemoveAll        (IPredFunc, void*) = 0;

  virtual
  INumber  RemoveAllElementsWithKey
                            (void const*); // = 0

  virtual
  INumber  RemoveAllOccurrences
                            (void const*); // = 0

  virtual
  void     RemoveAt         (ICursorImpl&) = 0;


  virtual
  void     RemoveAtPosition (IPosition); // = 0

  virtual
  bool RemoveElementWithKey
                            (void const*); // = 0

  virtual
  void     RemoveFirst      ();

  virtual
  void     RemoveLast       ();

  virtual
  void     ReplaceAt        (ICursorImpl const&, void const*) = 0;

  virtual
  void     ReplaceAtPosition
                            (IPosition, void const*);

  bool ReplaceElementWithKey
                            (void const*);

  virtual
  bool ReplaceElementWithKey
                            (void const*, ICursorImpl&); // = 0

  virtual
  void     Reverse          (); // = 0

  virtual
  void     Seize            (long timeout = -1);

  virtual
  bool SetToFirst       (ICursorImpl&) const = 0;

  virtual
  bool SetToLast        (ICursorImpl&) const; // = 0

  virtual
  bool SetToNext        (ICursorImpl&) const = 0;

  virtual
  bool SetToNextWithDifferentKey
                            (ICursorImpl&) const; // = 0

  virtual
  void     SetToPosition    (IPosition, ICursorImpl&) const; // = 0

  virtual
  bool SetToPrevious    (ICursorImpl&) const; // = 0

  virtual
  void     Sort             (ICompFunc, void*); // = 0

  virtual
  void     UnlockAfterReading
                            ();

  virtual
  void     UnlockAfterWriting
                            ();


protected:





  struct Predicate {

    static
    bool IsContained      (void const*, void*);

    static
    bool IsNotContained   (void const*, void*);

  };





           IACollectionImpl (Ops&);

           IACollectionImpl (IACollectionImpl const&);

  static
  inline
  ICursorImpl&
           CursorOf         (IACollectionImpl const&);

  static
  Ops&     OpsOf            (IACollectionImpl const&);
private:

  Ops*     ivOps;

  INumber  ivReferenceCount;

  ICursorImpl*
           ivDummyCursor;


  ICollectionResourceImpl*
           ivResource;


#if ! defined (__INO_STREAMING__)
protected:
  IStreamerPtr
           ivStreamer;

public:
  virtual
  IStreamerPtr&
           StreamerOf       (IACollectionImpl const&) = 0;

  virtual
  void     StreamIn         (IDataStream&) = 0;

  virtual
  void     StreamOut        (IDataStream&) const = 0;

  virtual
  void     AdoptStreamer    (IACollectionStreamer*) = 0;

  virtual
  void     WriteVersion     (IDataStream&) const;

  virtual
  void     ReadVersion      (IDataStream&);
#endif

























































































































};

class IC_EXPORTC IACollectionOps 
{
public:

  virtual ~IACollectionOps  ();

protected:

private:







};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iiacllct.inl>


#pragma info (restore)


#endif // _IIACLLCT_
