// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 61 1.5.1.4 source/core/collect/ihptab.h, collection, ioc.v400, 980918 
#ifndef _IHPTAB_
#define _IHPTAB_

#include <ilanglvl.hpp>
#include <iahp.h>
#include <iichp.h>

#include <iivhp.h>

#include <iihptab.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGHeapAsTable;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGHeapAsTableCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef TYPENAME IGHeapAsTable
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGHeapAsTableCursor
                            (IGHeapAsTable
                              <
                               Element, ElementOps> const&);

  IGHeapAsTableCursor <Element, ElementOps>&
           operator=        (IGHeapAsTableCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGHeapAsTableCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGHeapAsTable :
  public IAHeap <Element> {
protected:

  typedef  IGHeapAsTable <Element, ElementOps> Self;

  typedef  IHeapAsTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICHeapImpl
            <PureImplementation> Implementation;
#endif

#define IGHeapAsTableTypedef(Element, ElementOps)\
  typedef  IHeapAsTableOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGHeapAsTableTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGHeapAsTableCursor
            <Element, ElementOps> Cursor;




           IGHeapAsTable
                            (INumber = 100);

           IGHeapAsTable
                            (IGHeapAsTable
                              <
                               Element, ElementOps> const&);

  IGHeapAsTable <Element, ElementOps>&
           operator=        (IGHeapAsTable
                              <
                               Element, ElementOps> const&);



















protected:

           IGHeapAsTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGHeapAsTable
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGHeapAsTableCursor <Element, ElementOps>;






















};

template <class Element>
class IHeapAsTable :
  public IGHeapAsTable
          <Element, IStdOps <Element> > {

  typedef  IGHeapAsTable
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IHeapAsTable <Element> Self;

#define IHeapAsTableTypedef(Element)\
  typedef  IHeapAsTableOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IHeapAsTable
                            (INumber = 100);

















protected:

           IHeapAsTable
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGHeapAsTable :
  public IGHeapAsTable
          <Element, ElementOps > {

  typedef  IVGHeapAsTable
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGHeapAsTable
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVHeapImpl
            <PureImplementation> Implementation;
#else
  typedef  ICHeapImpl
            <IVHeapImpl
              <PureImplementation> > Implementation;
#endif

#define IVGHeapAsTableTypedef(Element, ElementOps)\
  typedef  IHeapAsTableOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGHeapAsTableTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGHeapAsTable
                            (INumber = 100);

















protected:

           IVGHeapAsTable
                              (PureImplementation&);

private:












};

template <class Element>
class IVHeapAsTable :
  public IVGHeapAsTable
          <Element, IStdOps <Element> > {

  typedef  IVGHeapAsTable
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVHeapAsTable <Element> Self;

#define IVHeapAsTableTypedef(Element)\
  typedef  IVHeapAsTableOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVHeapAsTable
                            (INumber = 100);

















protected:

           IVHeapAsTable
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <ihptab.inl>


#pragma info (restore)


#endif // _IHPTAB_
