// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 59 1.5.1.4 source/core/collect/ihplst.h, collection, ioc.v400, 980918 
#ifndef _IHPLST_
#define _IHPLST_

#include <ilanglvl.hpp>
#include <iahp.h>
#include <iichp.h>

#include <iivhp.h>

#include <iihplst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGHeapAsList;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGHeapAsListCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef TYPENAME IGHeapAsList
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGHeapAsListCursor
                            (IGHeapAsList
                              <
                               Element, ElementOps> const&);

  IGHeapAsListCursor <Element, ElementOps>&
           operator=        (IGHeapAsListCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGHeapAsListCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGHeapAsList :
  public IAHeap <Element> {
protected:

  typedef  IGHeapAsList <Element, ElementOps> Self;

  typedef  IHeapAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICHeapImpl
            <PureImplementation> Implementation;
#endif

#define IGHeapAsListTypedef(Element, ElementOps)\
  typedef  IHeapAsListOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGHeapAsListTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGHeapAsListCursor
            <Element, ElementOps> Cursor;




           IGHeapAsList
                            (INumber = 100);

           IGHeapAsList
                            (IGHeapAsList
                              <
                               Element, ElementOps> const&);

  IGHeapAsList <Element, ElementOps>&
           operator=        (IGHeapAsList
                              <
                               Element, ElementOps> const&);



















protected:

           IGHeapAsList
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGHeapAsList
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGHeapAsListCursor <Element, ElementOps>;






















};

template <class Element>
class IHeapAsList :
  public IGHeapAsList
          <Element, IStdOps <Element> > {

  typedef  IGHeapAsList
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IHeapAsList <Element> Self;

#define IHeapAsListTypedef(Element)\
  typedef  IHeapAsListOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IHeapAsList
                            (INumber = 100);

















protected:

           IHeapAsList
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGHeapAsList :
  public IGHeapAsList
          <Element, ElementOps > {

  typedef  IVGHeapAsList
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGHeapAsList
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVHeapImpl
            <PureImplementation> Implementation;
#else
  typedef  ICHeapImpl
            <IVHeapImpl
              <PureImplementation> > Implementation;
#endif

#define IVGHeapAsListTypedef(Element, ElementOps)\
  typedef  IHeapAsListOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGHeapAsListTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGHeapAsList
                            (INumber = 100);

















protected:

           IVGHeapAsList
                              (PureImplementation&);

private:












};

template <class Element>
class IVHeapAsList :
  public IVGHeapAsList
          <Element, IStdOps <Element> > {

  typedef  IVGHeapAsList
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVHeapAsList <Element> Self;

#define IVHeapAsListTypedef(Element)\
  typedef  IVHeapAsListOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVHeapAsList
                            (INumber = 100);

















protected:

           IVHeapAsList
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <ihplst.inl>


#pragma info (restore)


#endif // _IHPLST_
