// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 57 1.5.1.4 source/core/collect/ihpdil.h, collection, ioc.v400, 980918 
#ifndef _IHPDIL_
#define _IHPDIL_

#include <ilanglvl.hpp>
#include <iahp.h>
#include <iichp.h>

#include <iivhp.h>

#include <iihpdil.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGHeapAsDilTable;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGHeapAsDilTableCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef TYPENAME IGHeapAsDilTable
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGHeapAsDilTableCursor
                            (IGHeapAsDilTable
                              <
                               Element, ElementOps> const&);

  IGHeapAsDilTableCursor <Element, ElementOps>&
           operator=        (IGHeapAsDilTableCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGHeapAsDilTableCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGHeapAsDilTable :
  public IAHeap <Element> {
protected:

  typedef  IGHeapAsDilTable <Element, ElementOps> Self;

  typedef  IHeapAsDilTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICHeapImpl
            <PureImplementation> Implementation;
#endif

#define IGHeapAsDilTableTypedef(Element, ElementOps)\
  typedef  IHeapAsDilTableOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGHeapAsDilTableTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGHeapAsDilTableCursor
            <Element, ElementOps> Cursor;




           IGHeapAsDilTable
                            (INumber = 100);

           IGHeapAsDilTable
                            (IGHeapAsDilTable
                              <
                               Element, ElementOps> const&);

  IGHeapAsDilTable <Element, ElementOps>&
           operator=        (IGHeapAsDilTable
                              <
                               Element, ElementOps> const&);



















protected:

           IGHeapAsDilTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGHeapAsDilTable
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGHeapAsDilTableCursor <Element, ElementOps>;






















};

template <class Element>
class IHeapAsDilTable :
  public IGHeapAsDilTable
          <Element, IStdOps <Element> > {

  typedef  IGHeapAsDilTable
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IHeapAsDilTable <Element> Self;

#define IHeapAsDilTableTypedef(Element)\
  typedef  IHeapAsDilTableOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IHeapAsDilTable
                            (INumber = 100);

















protected:

           IHeapAsDilTable
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGHeapAsDilTable :
  public IGHeapAsDilTable
          <Element, ElementOps > {

  typedef  IVGHeapAsDilTable
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGHeapAsDilTable
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVHeapImpl
            <PureImplementation> Implementation;
#else
  typedef  ICHeapImpl
            <IVHeapImpl
              <PureImplementation> > Implementation;
#endif

#define IVGHeapAsDilTableTypedef(Element, ElementOps)\
  typedef  IHeapAsDilTableOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGHeapAsDilTableTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGHeapAsDilTable
                            (INumber = 100);

















protected:

           IVGHeapAsDilTable
                              (PureImplementation&);

private:












};

template <class Element>
class IVHeapAsDilTable :
  public IVGHeapAsDilTable
          <Element, IStdOps <Element> > {

  typedef  IVGHeapAsDilTable
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVHeapAsDilTable <Element> Self;

#define IVHeapAsDilTableTypedef(Element)\
  typedef  IVHeapAsDilTableOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVHeapAsDilTable
                            (INumber = 100);

















protected:

           IVHeapAsDilTable
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <ihpdil.inl>


#pragma info (restore)


#endif // _IHPDIL_
