// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 55 1.5.1.4 source/core/collect/ihp.h, collection, ioc.v400, 980918 
#ifndef _IHP_
#define _IHP_

#include <ilanglvl.hpp>
#include <iahp.h>
#include <iichp.h>

#include <iivhp.h>

#include <iihplst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGHeap;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGHeapCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef TYPENAME IGHeap
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGHeapCursor
                            (IGHeap
                              <
                               Element, ElementOps> const&);

  IGHeapCursor <Element, ElementOps>&
           operator=        (IGHeapCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGHeapCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGHeap :
  public IAHeap <Element> {
protected:

  typedef  IGHeap <Element, ElementOps> Self;

  typedef  IHeapAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICHeapImpl
            <PureImplementation> Implementation;
#endif

#define IGHeapTypedef(Element, ElementOps)\
  typedef  IHeapAsListOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGHeapTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGHeapCursor
            <Element, ElementOps> Cursor;




           IGHeap
                            (INumber = 100);

           IGHeap
                            (IGHeap
                              <
                               Element, ElementOps> const&);

  IGHeap <Element, ElementOps>&
           operator=        (IGHeap
                              <
                               Element, ElementOps> const&);



















protected:

           IGHeap
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGHeap
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGHeapCursor <Element, ElementOps>;






















};

template <class Element>
class IHeap :
  public IGHeap
          <Element, IStdOps <Element> > {

  typedef  IGHeap
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IHeap <Element> Self;

#define IHeapTypedef(Element)\
  typedef  IHeapAsListOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IHeap
                            (INumber = 100);

















protected:

           IHeap
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGHeap :
  public IGHeap
          <Element, ElementOps > {

  typedef  IVGHeap
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGHeap
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVHeapImpl
            <PureImplementation> Implementation;
#else
  typedef  ICHeapImpl
            <IVHeapImpl
              <PureImplementation> > Implementation;
#endif

#define IVGHeapTypedef(Element, ElementOps)\
  typedef  IHeapAsListOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGHeapTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGHeap
                            (INumber = 100);

















protected:

           IVGHeap
                              (PureImplementation&);

private:












};

template <class Element>
class IVHeap :
  public IVGHeap
          <Element, IStdOps <Element> > {

  typedef  IVGHeap
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVHeap <Element> Self;

#define IVHeapTypedef(Element)\
  typedef  IVHeapAsListOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVHeap
                            (INumber = 100);

















protected:

           IVHeap
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <ihp.inl>


#pragma info (restore)


#endif // _IHP_
