// Revision: 68 1.4.1.4 source/ui/baseapp/ihelphdr.hpp, help, ioc.v400, 980918 
#ifndef _IHELPHDR_
#define _IHELPHDR_
/*******************************************************************************
* FILE NAME: ihelphdr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IHelpHandler                                                             *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <ihandler.hpp>
#include <ihelpevt.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IFrameWindow;

#pragma enum(4)
#pragma pack(push,4)

class IHelpHandler : public IHandler {
typedef IHandler
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IHelpHandler ( );
virtual
 ~IHelpHandler ( );

/*---------------------------- Event Dispatching -----------------------------*/
virtual IHelpHandler
 &handleEventsFor       ( IFrameWindow* associatedWindow ),
 &stopHandlingEventsFor ( IFrameWindow* associatedWindow );

protected:
/*---------------------------- Event Dispatching -----------------------------*/
virtual bool
  dispatchHandlerEvent  ( IEvent& event );

/*----------------------------- Event Processing -----------------------------*/
virtual bool
  keysHelpId            ( IEvent&                    event ),
  subitemNotFound       ( IHelpSubitemNotFoundEvent& event ),
  helpUndefined         ( IEvent&                    event ),
  handleError           ( IHelpErrorEvent&           event ),
#ifndef IC_MOTIFWIN_FLAGNOP
  showTutorial          ( IHelpTutorialEvent&        event ),
#endif // IC_MOTIFWIN_FLAGNOP
  menuBarCommand        ( IHelpMenuBarEvent&         event ),
  hyperlinkSelect       ( IHelpHyperlinkEvent&       event ),
  controlSelect         ( IHelpNotifyEvent&          event );

#ifndef IC_MOTIF_FLAGNOP
virtual bool
  showContents          ( IHelpNotifyEvent&          event ),
  showCoverPage         ( IHelpNotifyEvent&          event ),
  showPage              ( IHelpNotifyEvent&          event ),
  swapPage              ( IHelpNotifyEvent&          event ),
  showHistory           ( IHelpNotifyEvent&          event ),
  showIndex             ( IHelpNotifyEvent&          event ),
  showSearchList        ( IHelpNotifyEvent&          event ),
  openLibrary           ( IHelpNotifyEvent&          event );
#endif // IC_MOTIF_FLAGNOP

private:
/*--------------------------------- Private ----------------------------------*/

/*------------------------------ Hidden Members ------------------------------*/
virtual IHandler
 &handleEventsFor       ( IWindow* window ),
 &stopHandlingEventsFor ( IWindow* window );

}; // IHelpHandler

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* IHELPHDR */
