// Revision: 66 1.4.1.3 source/ui/baseapp/ihelpevt.hpp, help, ioc.v400, 980918 
#ifndef _IHELPEVT_
#define _IHELPEVT_
/*******************************************************************************
* FILE NAME: ihelpevt.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the declaration(s) of the class(es):                    *
*     IHelpMenuBarEvent                                                        *
*     IHelpErrorEvent                                                          *
*     IHelpHypertextEvent (obsolete and replaced by IHelpHyperlinkEvent)       *
*     IHelpHyperlinkEvent                                                      *
*     IHelpSubitemNotFoundEvent                                                *
*     IHelpTutorialEvent                                                       *
*     IHelpNotifyEvent                                                         *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <ievent.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push,4)

class IHelpMenuBarEvent : public IEvent {
typedef IEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IHelpMenuBarEvent ( const IEvent& event );
virtual
 ~IHelpMenuBarEvent ( );

/*----------------------------- Menu Information -----------------------------*/
unsigned long
  commandId ( ) const;
}; // IHelpMenuBarEvent


class IHelpErrorEvent : public IEvent {
typedef IEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IHelpErrorEvent ( const IEvent& event );
virtual
 ~IHelpErrorEvent ( );

/*-------------------------------- Error Type --------------------------------*/
enum ErrorType {
  loadingDLL,
  noWindow,
  invalidAppHandle,
  invalidInstanceHandle,
  noHelpInstance,
  invalidQueryHandle,
  noHelpTable,
  invalidId,
  noIndex,
  noContent,
  openHelpFile,
  readHelpFile,
  closeHelpFile,
  invalidHelpFile,
  notEnoughMemory,
  unableFreeMemory,
  invalidHelpWindow,
  unopenDatabase,
  fontNotFound,
  unknown
}; // ErrorType

ErrorType
  error ( ) const;
}; // IHelpErrorEvent


class IHelpHyperlinkEvent : public IEvent {
typedef IEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IHelpHyperlinkEvent ( const IEvent& event );
virtual
 ~IHelpHyperlinkEvent ( );

/*----------------------------- Link Information -----------------------------*/
unsigned long
  id ( ) const;
}; // IHelpHyperlinkEvent


class IHelpSubitemNotFoundEvent : public IEvent {
typedef IEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IHelpSubitemNotFoundEvent ( const IEvent& event );
virtual
 ~IHelpSubitemNotFoundEvent ( );

/*-------------------------------- Help Item ---------------------------------*/
bool
  isWindow   ( ) const,
  isFrame    ( ) const,
  isMenu     ( ) const;

unsigned long
  topicId    ( ) const,
  subtopicId ( ) const;
}; // IHelpSubitemNotFoundEvent


class IHelpTutorialEvent : public IEvent {
typedef IEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IHelpTutorialEvent ( const IEvent& event );
virtual
 ~IHelpTutorialEvent ( );

/*--------------------------------- Tutorial ---------------------------------*/
IString
  tutorialName        ( )  const;
}; // IHelpTutorialEvent


class IHelpNotifyEvent : public IEvent {
typedef IEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IHelpNotifyEvent ( const IEvent& event );
virtual
 ~IHelpNotifyEvent ( );

/*------------------------------- Help Window --------------------------------*/
IWindowHandle
  windowHandle ( ) const;

/*----------------------------- Selected Control -----------------------------*/
unsigned long
  controlId ( ) const;
}; // IHelpNotifyEvent

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _IHELPEVT_
