// Revision: 58 1.7.1.4 source/ui/baseapp/ihandler.hpp, basewin, ioc.v400, 980918  
#ifndef _IHANDLER_
#define _IHANDLER_
/*******************************************************************************
* FILE NAME: ihandler.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IHandler                                                                 *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>
#include <ievent.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IString;
class IWindow;

#pragma enum(4)
#pragma pack(push,4)

class IHandler  {
public:
/*------------------------------- Constructors -------------------------------*/
  IHandler ( );
virtual
 ~IHandler ( );

/*--------------------- Enabling and Disabling Handlers ----------------------*/
virtual IHandler
 &enable    ( bool enable = true ),
 &disable   ( );

bool
  isEnabled ( ) const;

/*---------------------------- Event Dispatching -----------------------------*/
virtual IHandler
 &handleEventsFor       ( IWindow* window ),
 &stopHandlingEventsFor ( IWindow* window );

/*------------------------------- Diagnostics --------------------------------*/
virtual IString
  asString    ( ) const,
  asDebugInfo ( ) const;

protected:
/*---------------------------- Event Dispatching -----------------------------*/
virtual bool
  dispatchHandlerEvent ( IEvent& event ) = 0;

/*----------------------------- Event Processing -----------------------------*/
virtual IEventResult
  defaultProcedure ( IEvent& event );

private:
/*--------------------------------- Private ----------------------------------*/
friend class IWindow;
bool
  active;
unsigned
  numWindows;

}; // IHandler

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <ihandler.inl>

#endif // _IHANDLER_
