// Revision: 53 1.16.1.5 source/ui/baseapp/ihandle.hpp, datatype, ioc.v400, 980918 
#ifndef _IHANDLE_
#define _IHANDLE_
/*******************************************************************************
* FILE NAME: ihandle.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IWindowHandle                                                            *
*     IStringHandle                                                            *
*     IProfileHandle                                                           *
*     IMessageQueueHandle                                                      *
*     IAccelTblHandle                                                          *
*     ISystemPointerHandle                                                     *
*     ISystemBitmapHandle                                                      *
*     IContextHandle                                                           *
*     IDisplayHandle                                                           *
*     IMenuHandle                                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved                    *
*                                                                              *
*******************************************************************************/

#include <ibase.hpp>
#include <ievtdata.hpp>
#include <i2dghand.hpp>
#include <ibhandle.hpp>
#include <istring.hpp>
#include <iuipl.hpp>

struct _WidgetRec;
struct _XtAppStruct;
struct _XGC;
struct _XDisplay;
struct _XrmHashBucketRec;

extern "C" {

#ifdef IC_WIN

typedef void * (__stdcall
  IWinProc)( void *, unsigned long, void *, void * );

#endif

#ifndef IC_MVS
#ifndef IC_WIN

typedef void * _System
  IWinProc ( unsigned long, unsigned long, void *, void * );

#endif
#endif
}

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push,4)

class IWindowHandle {
public:
/*---------------------------------- Value -----------------------------------*/
typedef INativeWindowHandle Value;

/*------------------------------- Constructors -------------------------------*/
  IWindowHandle ( Value value=0 );

/*--------------------------------- Testing ----------------------------------*/
bool
  isValid ( ) const;

/*----------------------- Sending and Posting Events -------------------------*/
enum BroadcastTo {
  descendants,
  frames,
  frameDescendants
  };

IEventResult
  sendEvent  ( unsigned long           eventId,
               const IEventParameter1& parm1 = 0ul,
               const IEventParameter2& parm2 = 0ul ) const;

void
  sendEvents ( unsigned long           eventId,
               const IEventParameter1& parm1 = 0ul,
               const IEventParameter2& parm2 = 0ul,
               BroadcastTo             value = descendants ) const;

void
  postEvent  ( unsigned long           eventId,
               const IEventParameter1& parm1 = 0ul,
               const IEventParameter2& parm2 = 0ul ) const,

  postEvents ( unsigned long           eventId,
               const IEventParameter1& parm1 = 0ul,
               const IEventParameter2& parm2 = 0ul,
               BroadcastTo             value = descendants ) const;
/*------------------------------- Diagnostics --------------------------------*/

IString
  asString    ( ) const,
  asDebugInfo ( ) const;

friend ostream
 &operator << ( ostream&       aStream,
                const IWindowHandle& aHandle );

unsigned long
  asUnsigned  ( ) const;

/*-------------------------------- Operators ---------------------------------*/
  operator Value ( ) const;

private:
/*---------------------------------- Value -----------------------------------*/
Value
  fhandle;
}; // IWindowHandle


class ISystemPointerHandle : public IPointerHandle {
typedef IPointerHandle
  Inherited;
public:
/*------------------------ System Pointer Identifiers ------------------------*/
enum EPointerType {
  kArrow=0,
  kText=1,
  kWait=2,
  kMove=3,
  kSizeUpLeft=4,
  kSizeUpRight=5,
  kSizeDownLeft=6,
  kSizeDownRight=7,
  kSizeLeft=8,
  kSizeRight=9,
  kSizeUp=10,
  kSizeDown=11,
#ifdef IC_PMWIN
  kStandardApplication=12,
#endif
  kInformation=13,
  kQuestion=14,
  kError=15,
  kWarning=16,
  kIllegalOperation=17,
#ifdef IC_PMWIN
  kSingleFile=18,
  kMultipleFile=19,
  kFolder=20,
  kProgram=21,
#endif
  kDragFade=22,
  kSizeHorizontal=23,
  kSizeVertical=24
  };

/*------------------------------- Constructors -------------------------------*/
  ISystemPointerHandle ( EPointerType    pointerId,
                         bool            makeCopy = false );
 ~ISystemPointerHandle ( );

#if (IC_OBSOLETE <= IC_OBSOLETE_3)
enum Identifier {
  arrow=0,
  text=1,
  wait=2,
  move=3,
#ifdef IC_PMWIN
  sizeNWSE=4,
  sizeNESW=5,
#endif
  sizeHorizontal=6,
  sizeVertical=7,
#ifdef IC_PMWIN
  standardApplication=8,
#endif
  information=9,
  question=10,
  error=11,
  warning=12,
  illegalOperation=13,
#ifdef IC_PMWIN
  singleFile=14,
  multipleFile=15,
  folder=16,
  program=17,
#endif
  dragFade=18
  };

  ISystemPointerHandle ( Identifier      pointerId,
                         bool  makeCopy = false );
#endif // IC_OBSOLETE

}; // class ISysPointerHandle

class IStringHandle {
public:
/*---------------------------------- Value -----------------------------------*/
#ifdef IC_MOTIF
typedef void* Value;
#endif
#ifdef IC_PM
typedef unsigned long Value;
#endif
#ifdef IC_WIN
typedef void* Value;
#endif

/*------------------------------- Constructors -------------------------------*/
  IStringHandle ( Value value=0 );

/*------------------------------- Diagnostics --------------------------------*/

IString
  asString    ( ) const,
  asDebugInfo ( ) const;

friend ostream
 &operator << ( ostream&       aStream,
                const IStringHandle& aHandle );

unsigned long
  asUnsigned  ( ) const;

/*-------------------------------- Operators ---------------------------------*/
  operator Value ( ) const;

private:
/*---------------------------------- Value -----------------------------------*/
Value
  fhandle;
}; // IStringHandle


class ISystemBitmapHandle : public IBitmapHandle {
typedef IBitmapHandle
  Inherited;
public:
/*------------------------- System Bitmap Identifiers ------------------------*/
enum Identifier {
  systemMenu=0,
#ifdef IC_PMWIN
  systemMenuPressed=1,
  scrollBarUpArrow=2,
  scrollBarUpArrowPressed=3,
  scrollBarUpArrowDisabled=4,
  scrollBarDownArrow=5,
  scrollBarDownArrowPressed=6,
  scrollBarDownArrowDisabled=7,
  scrollBarRightArrow=8,
  scrollBarRightArrowPressed=9,
  scrollBarRightArrowDisabled=10,
  scrollBarLeftArrow=11,
  scrollBarLeftArrowPressed=12,
  scrollBarLeftArrowDisabled=13,
#endif
  menuCheckMark=14,
#ifdef IC_PMWIN
  menuAttached=15,
  checkBoxCheck=16,
  comboBoxDownArrow=17,
  pushButtonCorners=18,
#endif
  minimizeButton=19,
#ifdef IC_PMWIN
  minimizeButtonPressed=20,
#endif
  maximizeButton=21,
#ifdef IC_PMWIN
  maximizeButtonPressed=22,
#endif
  restoreButton=23,
#ifdef IC_PMWIN
  restoreButtonPressed=24,
  childSystemMenu=25,
  childSystemMenuPressed=26,
  drive=27,
#endif
  file=28
#ifdef IC_PMWIN
  ,
  folder=29,
  collapsedTree=30,
  expandedTree=31,
  program=32,
  sizeBox=33,
  smallSystemMenu=34
#endif
  };

/*------------------------------- Constructors -------------------------------*/
  ISystemBitmapHandle ( Identifier bitmapId );
 ~ISystemBitmapHandle ( );

}; // class ISystemBitmapHandle

class IProfileHandle {
public:
/*---------------------------------- Value -----------------------------------*/
#ifdef IC_MOTIF
typedef _XrmHashBucketRec* Value;
#endif
#ifdef IC_PM
typedef unsigned long Value;
#endif
#ifdef IC_WIN
typedef void* Value;
#endif

/*------------------------------- Constructors -------------------------------*/
  IProfileHandle ( Value value=0 );

/*------------------------------- Diagnostics --------------------------------*/

IString
  asString    ( ) const,
  asDebugInfo ( ) const;

friend ostream
 &operator << ( ostream&       aStream,
                const IProfileHandle& aHandle );

unsigned long
  asUnsigned  ( ) const;

/*-------------------------------- Operators ---------------------------------*/
  operator Value ( ) const;

private:
/*---------------------------------- Value -----------------------------------*/
Value
  fhandle;
}; // IProfileHandle

class IMessageQueueHandle {
public:
/*---------------------------------- Value -----------------------------------*/
#ifdef IC_MOTIF
typedef void* Value;
#endif
#ifdef IC_PM
typedef unsigned long Value;
#endif
#ifdef IC_WIN
typedef void* Value;
#endif

/*------------------------------- Constructors -------------------------------*/
  IMessageQueueHandle ( Value value=0 );

/*-------------------------------- Post Event --------------------------------*/
void
  postEvent  ( unsigned long           eventId,
               const IEventParameter1& parm1 = 0ul,
               const IEventParameter2& parm2 = 0ul ) const;
static void
  postEvent  ( const IMessageQueueHandle&    handle,
               unsigned long           eventId,
               const IEventParameter1& parm1 = 0ul,
               const IEventParameter2& parm2 = 0ul );
static void
  postEvents ( unsigned long           eventId,
               const IEventParameter1& parm1 = 0ul,
               const IEventParameter2& parm2 = 0ul );

/*------------------------------- Diagnostics --------------------------------*/

IString
  asString    ( ) const,
  asDebugInfo ( ) const;

friend ostream
 &operator << ( ostream&       aStream,
                const IMessageQueueHandle& aHandle );

unsigned long
  asUnsigned  ( ) const;

/*-------------------------------- Operators ---------------------------------*/
  operator Value ( ) const;

private:
/*---------------------------------- Value -----------------------------------*/
Value
  fhandle;
}; // IMessageQueueHandle

class IAccelTblHandle {
public:
/*---------------------------------- Value -----------------------------------*/
#ifdef IC_MOTIF
typedef void* Value;
#endif
#ifdef IC_PM
typedef unsigned long Value;
#endif
#ifdef IC_WIN
typedef void* Value;
#endif

/*------------------------------- Constructors -------------------------------*/
  IAccelTblHandle ( Value value=0 );

/*------------------------------- Diagnostics --------------------------------*/

IString
  asString    ( ) const,
  asDebugInfo ( ) const;

friend ostream
 &operator << ( ostream&       aStream,
                const IAccelTblHandle& aHandle );

unsigned long
  asUnsigned  ( ) const;

/*-------------------------------- Operators ---------------------------------*/
  operator Value ( ) const;

private:
/*---------------------------------- Value -----------------------------------*/
Value
  fhandle;
}; // IAccelTblHandle



#ifdef IC_MOTIF
class IDisplayHandle {
public:
/*---------------------------------- Value -----------------------------------*/
typedef _XDisplay* Value;

/*------------------------------- Constructors -------------------------------*/
  IDisplayHandle ( Value value=0 );

/*------------------------------- Diagnostics --------------------------------*/

IString
  asString    ( ) const,
  asDebugInfo ( ) const;

friend ostream
 &operator << ( ostream&       aStream,
                const IDisplayHandle& aHandle );

unsigned long
  asUnsigned  ( ) const;

/*-------------------------------- Operators ---------------------------------*/
  operator Value ( ) const;

private:
/*---------------------------------- Value -----------------------------------*/
Value
  fhandle;
}; // IDisplayHandle
#endif

#ifdef IC_WIN
class IMenuHandle {
public:
/*---------------------------------- Value -----------------------------------*/
typedef void* Value;

/*------------------------------- Constructors -------------------------------*/
  IMenuHandle ( Value value=0 );

/*------------------------------- Diagnostics --------------------------------*/

IString
  asString    ( ) const,
  asDebugInfo ( ) const;

friend ostream
 &operator << ( ostream&       aStream,
                const IMenuHandle& aHandle );

unsigned long
  asUnsigned  ( ) const;

/*-------------------------------- Operators ---------------------------------*/
  operator Value ( ) const;

private:
/*---------------------------------- Value -----------------------------------*/
Value
  fhandle;
}; // IMenuHandle
#endif
#ifdef IC_MOTIFPM
typedef IWindowHandle IMenuHandle;
#endif

#if (IC_OBSOLETE <= IC_OBSOLETE_3)

#ifdef IC_MOTIF
typedef IAnchorBlockHandle IContextHandle;
#endif

#endif // IC_OBSOLETE

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <ihandle.inl>

#endif // _IHANDLE_
