#ifndef _IGSTRING_
#define _IGSTRING_
/*******************************************************************************
* FILE NAME: igstring.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IGString                                                                 *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
// Revision: 69 1.3 source/ographic/igstring.hpp, graphics, ocdev

#include <ivbase.hpp>

#if ( IC_OBSOLETE <= IC_OBSOLETE_3 )
#ifdef IC_PMWIN

#include <igraphic.hpp>
#include <istring.hpp>
#include <ipoint.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push, 4)

class IResourceId;
class IFont;
class IGraphicContext;

class IGString : public IGraphic {
typedef IGraphic
  Inherited;

public:
/*------------------------------- Constructors -------------------------------*/
  IGString   ( const IString&  string,
               const IPoint&   point = IPoint() );

  IGString   ( const IString&  string,
               const IPoint&   point,
               const IFont&    font             );

  IGString   ( const IGString& graphicString    );

IGString
  &operator= ( const IGString& graphicString    );

virtual
  ~IGString  ( );

/*--------------------------------- Drawing ----------------------------------*/
virtual IGString
  &drawOn            ( IGraphicContext& graphicContext );

/*---------------------------------- Text ------------------------------------*/
virtual IGString
  &setText           ( const char*        text ),
  &setText           ( const IResourceId& text );

virtual IString
  text               ( ) const;

/*---------------------------------- Font ------------------------------------*/
virtual IGString
  &setFont           ( const IFont& font );

virtual IFont
  font               ( ) const;

virtual bool
  hasFont            ( ) const;

virtual IGString
  &removeFont        ( );

/*----------------------------- Text Positioning -----------------------------*/
virtual IGString
  &moveTo            ( const IPoint& point );

virtual IPoint
  position           ( ) const;

/*---------------------------- Clipping Rectangle ----------------------------*/
virtual IGString
  &setClippingRect   ( const IRectangle& rectangle );

virtual IRectangle
  clippingRect       ( ) const;

virtual IGString
  &resetClippingRect ( );

virtual bool
  isClippingRectSet  ( ) const;


/*-------------------------------- Comparison --------------------------------*/
bool
  operator== ( const IGString& graphicString ) const,
  operator!= ( const IGString& graphicString ) const;

private:
/*-------------------------------- Private -----------------------------------*/
IGString();
IString
  fString;
IPoint
  fLocation;
IFont
 *fFont;
IRectangle
 *fClip;
}; // IGString

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // IC_PMWIN
#endif // IC_OBSOLETE
#endif // _IGSTRING_
