// ----------------------------------------------------------------------------
//  FILE: igstream.hpp
//
//  This file declares the global streaming operators.
//
//  COPYRIGHT
//      IBM Open Class Library
//      (C) Copyright International Business Machines Corporation,  1997
//
//      Licensed Material - Program-Property of IBM - All Rights Reserved.
//
// Revision: 61 1.17.1.4 source/core/streams/igstream.hpp, oss, ioc.v400, 980918 
// ----------------------------------------------------------------------------

#ifndef _IGSTREAM_
#define _IGSTREAM_

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

//
// external class declarations.
//
class IDataStream;
class IMStreamable;

void operator<<=(IMStreamable& c, IDataStream& s);
void operator<<=(char& c, IDataStream& s);
void operator<<=(signed char& c, IDataStream& s);
void operator<<=(unsigned char& c, IDataStream& s);
void operator<<=(short& c, IDataStream& s);
void operator<<=(unsigned short& c, IDataStream& s);
void operator<<=(long& c, IDataStream& s);
void operator<<=(unsigned long& c, IDataStream& s);
void operator<<=(float& c, IDataStream& s);
void operator<<=(double& c, IDataStream& s);

void operator>>=(const IMStreamable& object, IDataStream& s);
void operator>>=(char c, IDataStream& s);
void operator>>=(signed char c, IDataStream& s);
void operator>>=(unsigned char c, IDataStream& s);
void operator>>=(short c, IDataStream& s);
void operator>>=(unsigned short c, IDataStream& s);
void operator>>=(long c, IDataStream& s);
void operator>>=(unsigned long c, IDataStream& s);
void operator>>=(float c, IDataStream& s);
void operator>>=(double c, IDataStream& s);

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <igstream.inl>

#endif
