// Revision: 80 1.7.1.5 source/ui/basectl/igroupbx.hpp, staticctls, ioc.v400, 980918 
#ifndef _IGROUPBX_
  #define _IGROUPBX_
/*******************************************************************************
* FILE NAME: igroupbx.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*    IGroupBox                                                                 *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <itextctl.hpp>
#include <irect.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class ISize;
class IWindowHandle;
class IGroupBoxData;
class IResourceId;

#pragma enum(4)
#pragma pack(push,4)

class IGroupBox : public ITextControl  {
typedef ITextControl
  Inherited;
public:
class Style;
/*------------------------- Constructors -------------------------------------*/
  IGroupBox ( unsigned             long id,
              IWindow*             parent,
              IWindow*             owner,
              const IRectangle&    initial= IRectangle(),
              const Style&         style = defaultStyle() );

  IGroupBox ( unsigned long        id,
              IWindow*             parentDialog );

  IGroupBox ( const IWindowHandle& handle );

virtual
 ~IGroupBox ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF1(Style, IGroupBox, IWindow);
                                  // style class definition
static const Style
  IC_IMPORTU classDefaultStyle;

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      bool         extendedOnly = false ) const;

/*---------------------------- Canvas Support --------------------------------*/
virtual IRectangle
  visibleRectangle   ( ) const;

#ifndef IC_WIN_FLAGNOP
/*----------------------------- Color Functions ------------------------------*/
virtual IColor
  foregroundColor () const;
#endif

#ifdef IC_MOTIF
virtual IGroupBox
 &setForegroundColor (const IColor &color),
 &setBackgroundColor (const IColor &color);

/*-------------------------- Text Processing ---------------------------------*/
virtual IString
  text                   ( ) const;
virtual ISize
  displaySize  ( const char* text = 0 ) const;
#endif

virtual IGroupBox
 &setText  ( const char*        text ),
 &setText  ( const IResourceId& text );

#ifdef IC_PMWIN
protected:
/*------------------------------- Layout -------------------------------------*/
virtual ISize
  calcMinimumSize() const;
#endif

/*---------------------------- Color Functions -------------------------------*/
#ifdef IC_MOTIF
virtual IGroupBox
 &setColor         ( unsigned long colorArea,
                     const IColor& color );
#endif
private:
/*--------------------------------- Private ----------------------------------*/
friend class IGroupHandler;

static Style
  currentDefaultStyle;

IGroupBoxData
 *fGroupBoxData;

/*---------------------------- Hidden Functions ------------------------------*/
  IGroupBox ( const IGroupBox& );
IGroupBox
 &operator= ( const IGroupBox& );

}; // class IGroupBox

INESTEDBITFLAGCLASSFUNCS(Style, IGroupBox)

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif  /* _IGROUPBX_ */
