/**
 * This file describes the exception class for 2D graphics.
 * Class described here is IGraphicExeption.
 *
 *   IBM Open Class Library
 *   (C) Copyright International Business Machines Corporation,  1997
 *   Licensed Material - Program-Property of IBM - All Rights Reserved.
 */

// Revision: 35 1.13.1.6 source/albert/graph2d/igrexept.hpp, 2d, ioc.v400, 980918 

#ifndef _IGREXEPT_
#define _IGREXEPT_

#include <iexcept.hpp>
#include <iprimtyp.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push,4)

/**
 * IGraphicException is an exception class defined for 2-D graphics.
 */

class IGraphicException : public IException {
public:

	/** Exception types for 2-D graphics */
	enum EGraphicExceptionType {
		kSingularTransform,
		kObjectNotInitialized,
		kUnknownEnumValue,
		kBelowRange,
		kAboveRange,
		kOutOfRange,
		kInvalidValue,
		kIndexAboveRange,
		kIndexOutOfRange,
		kLessThanOne,
		kWrongAreaOperation,
		kImageFontUsedInArea,
		kCoordinateLimitExceeded,
		kParameterAssertException,
		kInternalAssertException,
		kInitializedAssertException,
		kImplementedAssertException,
		kInternalExeption,
		kGenericGraphicException };
	
	/**
	 * Creates an exception with description text, error ID, and severity.
	 */
	IGraphicException(
		const char* errorText,
		unsigned long errorId = 0,
		Severity severity = IException::unrecoverable);

	/**
	 * Copy constructor.
	 */
	IGraphicException(const IGraphicException& other);

	virtual ~IGraphicException();

	/**
   *InternalAssert is invoked when there is an internal consistancy problem
   */
	static void InternalAssert(bool condition, const char* str);

private:
friend class IInternalGraphicException;
friend class IPrintGrafDevice; // IPrintGrafDevice::renderImage
	static void ParameterAssert(bool, const char*);
	static void InitializedAssert(bool, const char*);
	static void ImplementedAssert(const char*);
	static void ParameterException(bool, int);
	static void InternalException(bool, int);
	static void GrafDeviceException(const char*);
	static void GraphicExceptionMod(int);
	static void GraphicExceptionMod1(int, const char*);
	static void TransformException(int);

private:
	// IGraphicException();
	IGraphicException& operator=(const IGraphicException& other);
};

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _IGREXEPT_
