#ifndef _IGREGION_
#define _IGREGION_
/*******************************************************************************
* FILE NAME: igregion.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IGRegion                                                                 *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
// Revision: 67 1.3 source/ographic/igregion.hpp, graphics, ocdev

#include <ivbase.hpp>

#if ( IC_OBSOLETE <= IC_OBSOLETE_3 )
#ifdef IC_PMWIN

#include <igraphic.hpp>
#include <ihandle.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push, 4)

class IGraphicContext;
class IGRectangle;
class IGPolygon;
class IGEllipse;
class IGPie;
class IGChord;

class IGRegion : public IGraphic {
typedef IGraphic
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IGRegion   ( );

  IGRegion   ( const IRegionHandle&   regionHandle   );

  IGRegion   ( const IGRegion&        region         );

  IGRegion   ( const IGraphicContext& graphicContext,
               const IRectangle&      rectangle      );

  IGRegion   ( const IWindowHandle&   windowHandle   );

IGRegion
  &operator= ( const IGRegion&        region         );

virtual
  ~IGRegion  ( );

/*-------------------------------- Drawing -----------------------------------*/
virtual IGRegion
  &drawOn      ( IGraphicContext& graphicContext );

/*----------------------------- Positioning ----------------------------------*/
virtual IGRegion
  &moveBy      ( const IPoint& point );

/*-------------------------- Modifying a Region ------------------------------*/
virtual IGRegion
  &clear       ( );

/*------------------------ Operators With Closed Shapes ----------------------*/
IGRegion
  &operator+= ( const IGRectangle& rect    ),
  &operator-= ( const IGRectangle& rect    ),
  &operator&= ( const IGRectangle& rect    ),
  &operator^= ( const IGRectangle& rect    ),
  &operator+= ( const IGPie&       pie     ),
  &operator-= ( const IGPie&       pie     ),
  &operator&= ( const IGPie&       pie     ),
  &operator^= ( const IGPie&       pie     ),
  &operator+= ( const IGChord&     chord   ),
  &operator-= ( const IGChord&     chord   ),
  &operator&= ( const IGChord&     chord   ),
  &operator^= ( const IGChord&     chord   ),
  &operator+= ( const IGPolygon&   polygon ),
  &operator-= ( const IGPolygon&   polygon ),
  &operator&= ( const IGPolygon&   polygon ),
  &operator^= ( const IGPolygon&   polygon ),
  &operator+= ( const IGEllipse&   ellipse ),
  &operator-= ( const IGEllipse&   ellipse ),
  &operator&= ( const IGEllipse&   ellipse ),
  &operator^= ( const IGEllipse&   ellipse );

/*----------------------- Operators With Other IGRegions ---------------------*/
IGRegion
  &operator+= ( const IGRegion& region ),
  &operator-= ( const IGRegion& region ),
  &operator&= ( const IGRegion& region ),
  &operator^= ( const IGRegion& region );

/*------------------------------- Conversion ---------------------------------*/
operator const IRegionHandle( ) const;

private:
/*--------------------------------- Private ----------------------------------*/
IRegionHandle
  fRegion;
static IRegionHandle
  doRect    ( IGraphicContext& graphicContext, const IGRectangle& rect  ),
  doPie     ( IGraphicContext& graphicContext, const IGPie& pie         ),
  doChord   ( IGraphicContext& graphicContext, const IGChord& chord     ),
  doPolygon ( IGraphicContext& graphicContext, const IGPolygon& polygon ),
  doEllipse ( IGraphicContext& graphicContext, const IGEllipse& ellipse );
virtual IGRegion
  &rotateBy           ( double angle, const IPoint &pt ),
  &scaleBy            ( double xScale, double yScale, const IPoint& pt ),
  &translateBy        ( const IPoint& pt ),
  &setTransformMatrix ( const ITransformMatrix& transformMatrix );
}; // IGRegion

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // IC_PMWIN
#endif // IC_OBSOLETE
#endif // _IGREGION_
