#ifndef _IGRECT_
#define _IGRECT_
/*******************************************************************************
* FILE NAME: igrect.hpp                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IGRectangle                                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
// Revision: 66 1.2 source/ographic/igrect.hpp, graphics, ocdev

#include <ivbase.hpp>

#if ( IC_OBSOLETE <= IC_OBSOLETE_3 )
#ifdef IC_PMWIN

#include <igraphic.hpp>
#include <irect.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push, 4)

class IGraphicContext;

class IGRectangle : public IGraphic {
typedef IGraphic
  Inherited;

public:
/*------------------------------- Constructors -------------------------------*/
  IGRectangle ( const IRectangle&  rectangle = IRectangle() );

  IGRectangle ( const IGRectangle& gRectangle );

IGRectangle&
  operator=   ( const IGRectangle& gRectangle );

virtual
  ~IGRectangle ();

/*-------------------------------- Drawing -----------------------------------*/
virtual IGRectangle
  &drawOn            ( IGraphicContext& graphicContext );

/*---------------------------- Corner Rounding -------------------------------*/
virtual IGRectangle
  &setRounding       ( const IPair& ellipseAxis = IPair(0,0) );

virtual IPair
  rounding           ( ) const;

/*-------------------------- Enclosing Rectangle -----------------------------*/
virtual IGRectangle
  &setEnclosingRect  ( const IRectangle& rectangle );

virtual IRectangle
  enclosingRect      ( ) const;

/*-------------------------------- Comparison --------------------------------*/
bool
  operator==       ( const IGRectangle& gRectangle ) const,
  operator!=       ( const IGRectangle& gRectangle ) const;

private:
/*------------------------------- Private ------------------------------------*/
IRectangle
  fRect;
IPair
  fRounding;
}; // IGRectangle

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // IC_PMWIN
#endif // IC_OBSOLETE
#endif // _IGRECT_
