/**
 * This file describes pragma library definitions for graphics.
 *
 *   IBM Open Class Library
 *   (C) Copyright International Business Machines Corporation,  1997
 *   Licensed Material - Program-Property of IBM - All Rights Reserved.
 *
 */

// Revision: 70 1.12.1.8 source/albert/graph2d/igraphpl.hpp, 2d, ioc.v400, 980918 

#ifndef _IGRAPHPL_
#define _IGRAPHPL_

#include <ipraglib.h>		// PRAGMA_LIBRARY macro

#if !defined(__NO_DEFAULT_LIBS__)
    #if !defined(__NO_GRAPH2D_LIB__)
      	#if defined(__WINDOWS__)
            #if defined(_MSC_VER)   // MSVC
    		    #pragma comment(lib, OPENCLASS_LIBRARY_NAME_2(graph2d, og))
            #else                   // VAC
    		    #pragma library(OPENCLASS_LIBRARY_NAME_2(graph2d, og))
            #endif
            #if !defined(__IMPORTLIB__)
                #if defined(_MSC_VER)   // MSVC
                    #pragma comment(lib, "kernel32.lib")
                    #pragma comment(lib, "gdi32.lib")
                    #pragma comment(lib, "user32.lib")
                #else                   // VAC
                    #pragma library("kernel32.lib")
                    #pragma library("gdi32.lib")
                    #pragma library("user32.lib")
                #endif
                #include <ibasepl.hpp>      // need base library
            #endif
    	#elif defined(__OS2__)
        	#pragma library(OPENCLASS_LIBRARY_NAME_2(graph2d, og))
            #if !defined(__IMPORTLIB__)
                #pragma library("os2386.lib")
                #include <ibasepl.hpp>      // need base library
            #endif
      	#elif defined(_AIX)
      	    #if defined(__PRAGMA_LIBRARIES_VISIBLE__)
        		#pragma library(OPENCLASS_LIBRARY_NAME_2(graph2d, og))
                // If we are building static, AIX cmake needs to see these in order to
                // put library references in the makefile.
                #if !defined(__IMPORTLIB__)
                    #pragma library("libc_r.a")
                    #pragma library("libc.a")
                    #pragma library("libC_r.a")
                    #pragma library("libC.a")
                    #pragma library("libXm.a")
                    #pragma library("libXt.a")
                    #pragma library("libX11.a")
		    #pragma library("libi18n.a")
                    #include <ibasepl.hpp>      // need base library
                #endif // __IMPORTLIB__
            #endif // __PRAGMA_LIBRARIES_VISIBLE__
    	#endif // platform
    #else
        // This will be seen in the context of building the library only.
        #if defined(__WINDOWS__)
            #if defined(_MSC_VER)   // MSVC
                #pragma comment(lib, "kernel32.lib")
                #pragma comment(lib, "gdi32.lib")
                #pragma comment(lib, "user32.lib")
            #else                   // VAC
                #pragma library("kernel32.lib")
                #pragma library("gdi32.lib")
                #pragma library("user32.lib")
            #endif
        #elif defined(__OS2__)
            #pragma library("os2386.lib")
        #elif defined(_AIX)
            #if defined(__PRAGMA_LIBRARIES_VISIBLE__)
                // AIX doesn't support pragma library statments, but
                // include system libraries needed so cmake can find them.
                #pragma library("libc_r.a")
                #pragma library("libc.a")
                #pragma library("libC_r.a")
                #pragma library("libC.a")
                #pragma library("libXm.a")
                #pragma library("libXt.a")
                #pragma library("libX11.a")
	        #pragma library("libi18n.a")
            #endif // __PRAGMA_LIBRARIES_VISIBLE__
        #endif // _AIX
    #endif // __NO_GRAPH2D_LIB__
#endif  // __NO_DEFAULT_LIBS__

#endif // _IGRAPHPL_
