#ifndef _IGRAPHIC_
#define _IGRAPHIC_
/*******************************************************************************
* FILE NAME: igraphic.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IGraphic                                                                 *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
// Revision: 78 1.3 source/ographic/igraphic.hpp, graphics, ocdev

#include <ivbase.hpp>

#if ( IC_OBSOLETE <= IC_OBSOLETE_3 )
#ifdef IC_PMWIN

#include <irect.hpp>
#include <igbundle.hpp>
#include <itrnsfrm.hpp>
#include <ioldgpl.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push, 4)

class IGraphicContext;

class IGraphic : public IVBase {
typedef IVBase
  Inherited;
protected:
/*------------------------------- Constructors -------------------------------*/
  IGraphic   ( );
  IGraphic   ( const IGraphicBundle& graphicBundle );
  IGraphic   ( const IGraphic&       graphic       );

IGraphic
  &operator= ( const IGraphic&       graphic       );

public:

virtual
  ~IGraphic  ( );

/*---------------------------------- Drawing ---------------------------------*/
virtual IGraphic
  &drawOn                ( IGraphicContext& graphicContext ) = 0;

/*----------------------------- Bounding Rectangle ---------------------------*/
virtual IRectangle
  boundingRect           ( IGraphicContext& graphicContext );

/*---------------------------- Graphic Bundles -------------------------------*/
virtual IGraphic
  &setGraphicBundle      ( const IGraphicBundle& graphicBundle );

virtual IGraphicBundle
  graphicBundle          ( ) const;

virtual IGraphic
  &removeGraphicBundle   ( );

virtual bool
  hasGraphicBundle       ( ) const;

/*------------------------ World Space Transformation ------------------------*/
enum TransformMethod {
  replace,
  rightMultiply,
  leftMultiply
  };

virtual IGraphic
  &rotateBy              ( double                  angle,
                           const IPoint&           point = IPoint(0,0)  ),
  &scaleBy               ( double                  xScale,
                           double                  yScale,
                           const IPoint&           point = IPoint(0,0)   ),
  &translateBy           ( const IPoint&           point                 ),
  &setTransformMatrix    ( const ITransformMatrix& transformMatrix       ),
  &setTransformMethod    ( TransformMethod         transformMethod = rightMultiply );

virtual bool
  hasTransformMatrix     ( ) const;

const ITransformMatrix
  transformMatrix        ( ) const;

IGraphic::TransformMethod
  transformMethod        ( ) const;

virtual IGraphic
  &resetTransformMatrix  ( );

/*--------------------------------- Hit Testing ------------------------------*/
virtual bool
  contains               ( IGraphicContext& graphicContext,
                           const IPoint&    point                );

virtual IGraphic
  &setHitSelected        ( bool   hitSelected = false  );

virtual bool
  isHitSelected          ( ) const;

virtual IGraphic
  &setHitSelectable      ( bool   hitSelectable = true );

virtual bool
  isHitSelectable        ( ) const;

/*------------------------------ Object Identifier ---------------------------*/
virtual IGraphic
  &setId                 ( unsigned long identifier );

virtual unsigned long
  id                     ( ) const;

protected:

/*------------------------------- Comparison ---------------------------------*/
bool
  operator == ( const IGraphic& graphic ) const,
  operator != ( const IGraphic& graphic ) const;

/*-------------------------------- Private -----------------------------------*/
private:
unsigned long
  fId;
TransformMethod
  fTm;
IGraphicBundle
 *fBundle;
ITransformMatrix
 *fTransMat;
bool
  fSelected,
  fSelectable,
  fIsList;
friend class IGList;
}; // IGraphic

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // IC_PMWIN
#endif // IC_OBSOLETE
#endif // _IGRAPHIC_
