// Revision: 76 1.5.1.5 source/ui/basectl/igraphbt.hpp, buttonctls, ioc.v400, 980918 
#ifndef _IGRAPHBT_
  #define _IGRAPHBT_
/*******************************************************************************
* FILE NAME: igraphbt.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*    IGraphicPushButton                                                        *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
#include <ipushbut.hpp>
#include <irect.hpp>
#include <ipoint.hpp>
#include <ihandle.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IIconControl;
class IGraphicPushButtonData;
class IResourceId;

#pragma enum(4)
#pragma pack(push,4)

class IGraphicPushButton : public IPushButton  {
typedef IPushButton
  Inherited;
public:
class Style;
/*------------------------------- Constructors -------------------------------*/
  IGraphicPushButton( unsigned long         id,
                      IWindow*              parent,
                      IWindow*              owner,
                      const IResourceId&    bitmapOrIconId,
                      const IRectangle&     initial = IRectangle(),
                      const Style&          style = defaultStyle() );

  IGraphicPushButton( unsigned long         id,
                      IWindow*              parent,
                      IWindow*              owner,
                      unsigned long         bitmapOrIconId,
                      const IRectangle&     initial = IRectangle(),
                      const Style&          style = defaultStyle() );

  IGraphicPushButton( unsigned long         id,
                      IWindow*              parent,
                      IWindow*              owner,
                      const IBitmapHandle&  bitmap = IBitmapHandle(),
                      const IRectangle&     initial = IRectangle(),
                      const Style&          style = defaultStyle() );

  IGraphicPushButton( unsigned long         id,
                      IWindow*              parent,
                      IWindow*              owner,
                      const IPointerHandle& icon,
                      const IRectangle&     initial = IRectangle(),
                      const Style&          style = defaultStyle() );

  IGraphicPushButton( unsigned long         id,
                      IWindow*              parent );

  IGraphicPushButton( const IWindowHandle&  handle);

virtual
 ~IGraphicPushButton( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF4(Style, IGraphicPushButton, IWindow,
                        IControl, IButton, IPushButton);

static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU sizeImageToWindow,
  IC_IMPORTU sizeWindowToImage;

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      bool         extendedOnly = false ) const;

/*--------------------------------- Graphic ----------------------------------*/
enum GraphicType {
  bitmapType,
  iconType
};

virtual IGraphicPushButton
 &setGraphic         ( unsigned long         bitmapOrIconId ),
 &setGraphic         ( const IResourceId&    bitmapOrIconId ),
 &setGraphic         ( const IBitmapHandle&  handle ),
 &setGraphic         ( const IPointerHandle& handle );
IPointerHandle
  icon               ( ) const;
IBitmapHandle
  bitmap             ( ) const;
GraphicType
  currentGraphicType ( ) const;
#ifdef IC_PMWIN
IIconControl&
  graphicWindow      ( ) const;
#endif //IC_PMWIN

/*----------------------------- Graphic Size ---------------------------------*/
virtual IGraphicPushButton
  &enableSizeImageToWindow  ( bool enable = true ),
  &disableSizeImageToWindow ( );
virtual bool
  isSizeImageToWindowEnabled( ) const;

virtual IGraphicPushButton
  &enableSizeWindowToImage  ( bool enable = true ),
  &disableSizeWindowToImage ( );
virtual bool
  isSizeWindowToImageEnabled( ) const;

/*---------------------------------- Margins ---------------------------------*/
IGraphicPushButton
 &setMarginSize   ( const ISize& size );
ISize
  marginSize      ( ) const;

/*-------------------------------- Attributes --------------------------------*/
#ifdef IC_MOTIF
virtual IWindow
 &enable                    ( bool           enableWindow = true );
#endif //IC_MOTIF

protected:
/*------------------------------ Layout Support ------------------------------*/
virtual ISize
  calcMinimumSize ( ) const;

private:
/*------------------------------ Hidden Members ------------------------------*/
  IGraphicPushButton  (const IGraphicPushButton& button );
IGraphicPushButton
 &operator=           (const IGraphicPushButton& button );

/*--------------------------------- Private ----------------------------------*/
friend class IGraphicPushButtonHandler;

IGraphicPushButton
 &initialize( const Style& style,
              const IRectangle& initial,
              unsigned long id );

#ifndef IC_MOTIF_FLAGNOP
IGraphicPushButton
 &setControlData( const IBitmapHandle& handle );
#endif

static Style
  currentDefaultStyle;

#ifdef IC_PMWIN
IIconControl*
  aIcon;
bool
  returnBack;
GraphicType
  contains;
#endif
ISize
  border;

IGraphicPushButtonData
 *fGraphicPushButtonData;

/*----------------------- Obsolete Data and Functions ------------------------*/
#if (IC_OBSOLETE <= IC_OBSOLETE_3)
public:
static const Style
  IC_IMPORTU sizeToGraphic;

virtual IGraphicPushButton
 &enableSizeToGraphic   ( bool sizeToGraphic = true ),
 &disableSizeToGraphic  ( );
bool
  isSizeToGraphic       ( ) const;
#endif // IC_OBSOLETE

};  // class IGraphicPushButton

INESTEDBITFLAGCLASSFUNCS(Style, IGraphicPushButton)

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif  // _IGRAPHBT_
