// Revision: 85 1.12.1.4 source/albert/graph2d/graftext/igraftxt.hpp, text, ioc.v400, 980918 
// IGraphicText
/*******************************************************************************
* FILE NAME: igraftxt.hpp                                                      *
*       IBM Open Class Library                                                 *
*       (C) Copyright International Business Machines Corporation 1997         *
*       Licensed Material - Program-Property of IBM - All Rights Reserved.     *
*******************************************************************************/

#ifndef _IGRAFTXT_
#define _IGRAFTXT_


#include <igraph2d.hpp>
#include <itext.hpp>
#include <i2dghand.hpp> // IPresSpaceHandle
#include <igraphpl.hpp>                 // pragma library definitions

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IGrafPort;
class ICachedState;     // internal class

#pragma enum(4)
#pragma pack(push,4)

/////////////////////////////////////////////////////////////
//
// IGraphicText
//   Graphically displays mixed style text.
//
////////////////////////////////////////////////////////////

class IGraphicText: public IMGraphic
{
  StreamableDeclarationsMacro(IGraphicText);

public:
  enum ELineBreak {
        kFirstLineOnly,         // draw only the first line
        kAllOnOneLine,          // ignore paragraph and line breaks, and draw all the text on a single line
        kMultipleLines,         // draw multiple lines, honoring the wrap width and paragraph styles

        kSingleLine = kFirstLineOnly    // for compatibility with the old API
  };

 //-----------------------------------------------------
 // Constructors, destructor, assignment
 //-----------------------------------------------------

  IGraphicText(const IText& text, ELineBreak lb);
  IGraphicText(const IText& text, GCoordinate wrapWidth);
  IGraphicText(const IText& text, const IGRect2D& bounds);
  IGraphicText(const IGraphicText&);
  virtual ~IGraphicText();

  IGraphicText& operator=(const IGraphicText&);

 //-----------------------------------------------------
 // IMGraphic override
 //-----------------------------------------------------
  virtual void draw(IGrafPort&) const;

  virtual void transformBy(const IGrafMatrix&);

  virtual IGRect2D geometricBounds() const;
  virtual IGRect2D looseFitBounds(const IGrafPort* port = 0) const;

  virtual bool operator==(const IMDrawable&) const;

 //-----------------------------------------------------
 // Getters and setters
 //-----------------------------------------------------
  virtual void setLocation(const IGPoint2D&);
  virtual IGPoint2D location() const;

  virtual void setTransform(const IGrafMatrix&);
  virtual IGrafMatrix transform() const;

  virtual void setText(const IText&);
  virtual IText text() const;

  void setLineBreak(ELineBreak lb);
  ELineBreak lineBreak() const;

  void setWrapWidth(GCoordinate newWidth);
  GCoordinate wrapWidth() const;

   IGRect2D textBounds(const IGrafPort* port = 0) const;

   void portHasChanged();

public:
  // used by streaming only
  IGraphicText();

protected:
  virtual void writeToStream(IDataStream&) const;
  virtual void readFromStream(IDataStream&);

private:
  IText fText;
  IGrafMatrix fMatrix;
  ELineBreak fLineBreak;
  GCoordinate fWrapWidth;
  bool fPreserveULHC;
  ICachedState* fCachedState;

  ICachedState* getCachedState(const IGrafPort* port) const;
  void dumpCachedState();

  friend class ICachedState;
};

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _IGRAFTXT_

