#ifndef _IGRAFCTX_
#define _IGRAFCTX_
/*******************************************************************************
* FILE NAME: igrafctx.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IGraphicContext                                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
// Revision: 63 1.2 source/ographic/igrafctx.hpp, graphics, ocdev

#include <ivbase.hpp>

#if ( IC_OBSOLETE <= IC_OBSOLETE_3 )
#ifdef IC_PMWIN

#include <icolor.hpp>
#include <igbundle.hpp>
#include <ihandle.hpp>
#include <irect.hpp>
#include <igraphic.hpp>
#include <itrnsfrm.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push, 4)

class IGLine;
class IGPolyline;
class IGPolygon;
class IGRectangle;
class IGEllipse;
class IGArc;
class IG3PointArc;
class IGPie;
class IGChord;
class IGString;
class IGList;
class IFont;
class IGraphic;
class IGPicture;
class IGRegion;
class IGCData;

#ifdef IC_WU
   // To get around a conflict with the #define of None in <X.h>
   #ifdef None
      #undef None
   #endif
#endif

class IGraphicContext : public IVBase {
typedef IVBase
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IGraphicContext( );

  IGraphicContext( const IPresSpaceHandle& presSpaceHandle );

  IGraphicContext( const IWindowHandle&    windowHandle    );

  IGraphicContext( const ISize&            contextSize     );

virtual
  ~IGraphicContext();

/*----------------------------- Mapping Modes --------------------------------*/
enum MappingMode {
  pels,
  lowMetric,
  highMetric,
  lowEnglish,
  highEnglish,
  twips,
  isotropic
  };

virtual IGraphicContext
  &setMappingMode        ( MappingMode mappingMode = pels );

virtual MappingMode
  mappingMode            ( ) const;

/*------------------------- Device Space Transformation ----------------------*/
virtual IGraphicContext
  &setPageSize           ( const ISize& pageSize               );

virtual ISize
  pageSize               ( ) const;

virtual IGraphicContext
  &setViewPortRect       ( const IRectangle& viewportRectangle );

virtual IRectangle
  viewPortRect           ( ) const;


/*-------------------------------- Drawing -----------------------------------*/
virtual IGraphicContext
  &draw         ( const IGLine&      line             ),
  &draw         ( const IGPolyline&  polyline         ),
  &draw         ( const IGPolygon&   polygon          ),
  &draw         ( const IGEllipse&   geometry         ),
  &draw         ( const IGRectangle& graphicRectangle ),
  &draw         ( const IGArc&       arc              ),
  &draw         ( const IG3PointArc& arc              ),
  &draw         ( const IGPie&       pie              ),
  &draw         ( const IGChord&     chord            ),
  &draw         ( const IGString&    graphicString    ),
  &draw         ( const IGList&      list             ),
  &draw         ( const IGRegion&    region           );

/*------------------------------ Recoordination ------------------------------*/
IGraphicContext
  &setRecoordinationHeight    ( unsigned long height );

unsigned long
  recoordinationHeight        ( ) const;

/*----------------------------- Default Attributes ---------------------------*/
static void
  setDefaultPenColor          ( const IColor&                     penColor       ),
  setDefaultFillColor         ( const IColor&                     fillColor      ),
  setDefaultBackgroundColor   ( const IColor&                     backgroundColor),
  setDefaultDrawOperation     ( IGraphicBundle::DrawOperation     drawOperation  ),
  setDefaultMixMode           ( IGraphicBundle::MixMode           mixMode        ),
  setDefaultBackgroundMixMode ( IGraphicBundle::BackgroundMixMode backMixMode    ),
  setDefaultPenType           ( IGraphicBundle::PenType           penType        ),
  setDefaultPenEndingStyle    ( IGraphicBundle::PenEndingStyle    penEndingStyle ),
  setDefaultPenJoiningStyle   ( IGraphicBundle::PenJoiningStyle   penJoiningStyle),
  setDefaultPenWidth          ( unsigned long                     penWidth       ),
  setDefaultPenPattern        ( unsigned long                     penPattern     ),
  setDefaultFillPattern       ( unsigned long                     fillPattern    ),
  setDefaultPatternOrigin     ( const IPoint&                     point          );

static IColor
  defaultPenColor                        ( ),
  defaultFillColor                       ( ),
  defaultBackgroundColor                 ( );
static IGraphicBundle::DrawOperation
  defaultDrawOperation                   ( );
static IGraphicBundle::MixMode
  defaultMixMode                         ( );
static IGraphicBundle::BackgroundMixMode
  defaultBackgroundMixMode               ( );
static IGraphicBundle::PenType
  defaultPenType                         ( );
static IGraphicBundle::PenEndingStyle
  defaultPenEndingStyle                  ( );
static IGraphicBundle::PenJoiningStyle
  defaultPenJoiningStyle                 ( );
static unsigned long
  defaultPenWidth                        ( );
static unsigned long
  defaultPenPattern                      ( ),
  defaultFillPattern                     ( );
static IPoint
  defaultPatternOrigin                   ( );


/*-------------------------------- Attributes --------------------------------*/
virtual IGraphicContext
  &setGraphicBundle     ( const IGraphicBundle&             graphicBundle     ),
  &setPenColor          ( const IColor&                     penColor          ),
  &setBackgroundColor   ( const IColor&                     backgroundColor   ),
  &setFillColor         ( const IColor&                     fillColor         ),
  &setDrawOperation     ( IGraphicBundle::DrawOperation     drawOperation     ),
  &setMixMode           ( IGraphicBundle::MixMode           mixMode           ),
  &setBackgroundMixMode ( IGraphicBundle::BackgroundMixMode backgroundMixMode ),
  &setPenType           ( IGraphicBundle::PenType           penType           ),
  &setPenEndingStyle    ( IGraphicBundle::PenEndingStyle    penEndingStyle    ),
  &setPenJoiningStyle   ( IGraphicBundle::PenJoiningStyle   penJoiningStyle   ),
  &setPenWidth          ( unsigned long                     width             ),
  &setPenPattern        ( unsigned long                     penPattern        ),
  &setFillPattern       ( unsigned long                     fillPattern       ),
  &setPatternOrigin     ( const IPoint&                     point             );

virtual IGraphicBundle
  graphicBundle                            ( ) const;
virtual IColor
  penColor                                 ( ) const,
  backgroundColor                          ( ) const,
  fillColor                                ( ) const;
virtual IGraphicBundle::DrawOperation
  drawOperation                            ( ) const;
virtual IGraphicBundle::MixMode
  mixMode                                  ( ) const;
virtual IGraphicBundle::BackgroundMixMode
  backgroundMixMode                        ( ) const;
virtual IGraphicBundle::PenType
  penType                                  ( ) const;
virtual IGraphicBundle::PenEndingStyle
  penEndingStyle                           ( ) const;
virtual IGraphicBundle::PenJoiningStyle
  penJoiningStyle                          ( ) const;
virtual unsigned long
  penWidth                                 ( ) const;
virtual unsigned long
  penPattern                               ( ) const,
  fillPattern                              ( ) const;
virtual IPoint
  patternOrigin                            ( ) const;

/*------------------------------ Font Operations -----------------------------*/
virtual IGraphicContext
  &setFont                    ( const IFont& font ),
  &resetFont                  ( );

virtual IFont
  currentFont                 ( ) const;
virtual bool
  hasFont                     ( ) const;

/*--------------------------- Region operations ------------------------------*/
virtual IGraphicContext
  &clearClipRegion ( ),
  &setClipRegion   ( const IRegionHandle& region ),
  &setClipRegion   ( const IGRegion&      region );

virtual IRegionHandle
  clipRegion       ( ) const;

/*------------------------- World Space Transformation -----------------------*/
virtual IGraphicContext
  &setWorldTransformMatrix ( const ITransformMatrix&   transformMatrix,
                             IGraphic::TransformMethod method = IGraphic::replace );
virtual ITransformMatrix
  worldTransformMatrix     ( ) const;

/*--------------------------- Boundary Accumulation --------------------------*/
virtual IGraphicContext
  &startBoundaryAccumulation ( );

virtual IRectangle
  stopBoundaryAccumulation   ( );

virtual IGraphicContext
  &addToBoundingRect         ( const IRectangle& rectangle );

virtual bool
  isAccumulatingBoundingRect ( ) const;

/*------------------------------ Hit Testing ---------------------------------*/
virtual IGraphicContext
  &startHitTesting           ( ),
  &stopHitTesting            ( ),
  &setHitPoint               ( const IPoint& hitPoint  ),
  &setHitApertureSize        ( const ISize&  hitSize   );
bool
  isHitTesting               ( ) const;

virtual IPoint
  hitPoint                   ( ) const;

virtual ISize
  hitApertureSize            ( ) const;

/*------------------------------- Conversions --------------------------------*/
IPresSpaceHandle
  handle                     ( ) const;

/*----------------------- Current Drawing Position ---------------------------*/
virtual IGraphicContext
  &setCurrentDrawingPosition  ( const IPoint& point );

virtual IPoint
  currentDrawingPosition      ( ) const;

private:
/*------------------------------- Private ------------------------------------*/

IGraphicContext( const IGraphicContext& gc );
IGraphicContext& operator=( const IGraphicContext& );
IGraphicContext
  &apply( const IGraphic&   graphic,
          ITransformMatrix& transformMatrix,
          IGraphicBundle&   graphicBundle ),
  &remove( const IGraphic&   graphic,
           ITransformMatrix& transformMatrix,
           IGraphicBundle&   graphicBundle );
IGraphicContext
  &initialize();
static IColor
  fgCDPenColor,
  fgCDFillColor,
  fgCDBackgroundColor;
static IGraphicBundle::DrawOperation
  fgCDDrawOperation;
static IGraphicBundle::MixMode
  fgCDMixMode;
static IGraphicBundle::BackgroundMixMode
  fgCDBackgroundMixMode;
static unsigned long
  fgCDPenPattern,
  fgCDFillPattern;
static IGraphicBundle::PenType
  fgCDPenType;
static IGraphicBundle::PenEndingStyle
  fgCDPenEndingStyle;
static IGraphicBundle::PenJoiningStyle
  fgCDPenJoiningStyle;
static unsigned long
  fgCDPenWidth;
static IPoint
  fgCDPatternOrigin;
IGCData
 *fGCData;
IPresSpaceHandle
  fPs;
IColor
  fFillColor;
unsigned long
  fFillPattern;
IGraphicBundle::DrawOperation
  fDrawOp;
IFont
 *fFont;
enum CreateMethod
  { WindowHandle, Graphics, None };
CreateMethod
  fCm;
unsigned long
  fDc;
IBitmapHandle
  fBitmap;
}; // IGraphicContext

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // IC_PMWIN
#endif // IC_OBSOLETE
#endif // _IGRAFCTX_
