#ifndef _IGPYLINE_
#define _IGPYLINE_
/*******************************************************************************
* FILE NAME: IPLYLINE.HPP                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IGPolyline                                                               *
*     IGPolygon                                                                *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
// Revision: 62 1.2 source/ographic/igpyline.hpp, graphics, ocdev

#include <ivbase.hpp>

#if ( IC_OBSOLETE <= IC_OBSOLETE_3 )
#ifdef IC_PMWIN

#include <igraphic.hpp>
#include <iptarray.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push, 4)

class IGraphicContext;

class IGPolyline : public IGraphic {
typedef IGraphic
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IGPolyline  ( const IPointArray& pointArray );

  IGPolyline  ( const IGPolyline&  polyline   );

IGPolyline
  &operator=  ( const IGPolyline&  polyline   );

virtual
  ~IGPolyline ( );

/*-------------------------------- Drawing -----------------------------------*/
virtual IGPolyline
  &drawOn             ( IGraphicContext& graphicContext );

/*------------------------------- Data Points --------------------------------*/
virtual unsigned long
  numberOfPoints      ( ) const;

const IPointArray
  &pointArray         ( ) const;
const IPoint
  &point              ( unsigned long      index      ) const;

virtual IGPolyline
  &setPoints          ( const IPointArray& pointArray ),
  &setPoint           ( unsigned long      index,
                        const IPoint&      point      ),
  &insertPoint        ( unsigned long      index,
                        const IPoint&      point      ),
  &addPoint           ( const IPoint&      point      ),
  &removePoint        ( unsigned long      index      ),
  &reversePoints      ( );

/*-------------------------------- Comparison --------------------------------*/
bool
  operator== ( const IGPolyline& polyline ) const,
  operator!= ( const IGPolyline& polyline ) const;

private:
/*-------------------------------- Private -----------------------------------*/
IPointArray
  fPtArray;
}; // IGPolyline


class IGPolygon : public IGPolyline {
typedef IGPolyline
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IGPolygon  ( const IPointArray& pointArray );

  IGPolygon  ( const IGPolygon&   polygon    );

IGPolygon&
  operator=  ( const IGPolygon&   polygon    );

virtual
  ~IGPolygon ( );

/*-------------------------------- Drawing -----------------------------------*/
virtual IGPolygon
  &drawOn           ( IGraphicContext& graphicContext );

/*--------------------------------- Fill Mode --------------------------------*/
enum FillMode {
  alternate,
  winding
  };

virtual IGPolygon
  &setFillMode      ( FillMode fillmode );

virtual FillMode
  fillMode          ( ) const;

/*-------------------------------- Comparison --------------------------------*/
bool
  operator== ( const IGPolygon& polygon ) const,
  operator!= ( const IGPolygon& polygon ) const;

private:
/*-------------------------------- Private -----------------------------------*/
FillMode
  fFm;
}; // IGPolygon

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // IC_PMWIN
#endif // IC_OBSOLETE
#endif // _IGPYLINE_
