#ifndef _IGPIE_
#define _IGPIE_
/*******************************************************************************
* FILE NAME: igpie.hpp                                                         *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IGPie                                                                    *
*     IGChord                                                                  *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
// Revision: 60 1.2 source/ographic/igpie.hpp, graphics, ocdev

#include <ivbase.hpp>

#if ( IC_OBSOLETE <= IC_OBSOLETE_3 )
#ifdef IC_PMWIN

#include <igraphic.hpp>
#include <ipoint.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push, 4)

class IGraphicContext;

class IGPie : public IGraphic {
typedef IGraphic
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IGPie     ( const IRectangle& rectangle,
              double            startAngle,
              double            sweepAngle  );

  IGPie     ( const IGPie&      pie         );

IGPie&
  operator= ( const IGPie& pie              );

virtual
  ~IGPie    ( );

/*-------------------------------- Drawing -----------------------------------*/
virtual IGPie
  &drawOn          ( IGraphicContext& graphicContext );

/*-------------------------- Enclosing Rectangle -----------------------------*/
virtual IGPie
  &setEnclosingRect   ( const IRectangle &rectangle );

virtual IRectangle
  enclosingRect       ( ) const;

/*------------------------- Start and Sweep Angles ---------------------------*/
virtual IGPie
  &setStartAngle   ( double startAngle ),
  &setSweepAngle   ( double sweepAngle );

virtual double
  startAngle       ( ) const,
  sweepAngle       ( ) const;

/*-------------------------------- Comparison --------------------------------*/
bool
  operator== ( const IGPie& pie ) const,
  operator!= ( const IGPie& pie ) const;

private:
/*-------------------------------- Private -----------------------------------*/
IRectangle
  fRect;
long
  fStart,
  fSweep;
}; // IGPie

class IGChord : public IGPie {
typedef IGPie
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IGChord  ( const IRectangle& rectangle,
             double            startAngle,
             double            sweepAngle   );

  IGChord  ( const IGChord&    chord        );

virtual
  ~IGChord ( );

/*-------------------------------- Drawing -----------------------------------*/
virtual IGChord
  &drawOn( IGraphicContext& graphicContext );

}; // IGChord

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // IC_PMWIN
#endif // IC_OBSOLETE
#endif // _IGPIE_
