#ifndef _IGLIST_
#define _IGLIST_
/*******************************************************************************
* FILE NAME: iglist.hpp                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IGList                                                                   *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
// Revision: 58 1.2 source/ographic/iglist.hpp, graphics, ocdev

#include <ivbase.hpp>

#if ( IC_OBSOLETE <= IC_OBSOLETE_3 )
#ifdef IC_PMWIN

#include <igraphic.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push, 4)

class IGraphicContext;
class ITransformMatrix;
class IGListSeq;

class IGList : public IGraphic {
typedef IGraphic
  Inherited;

public:
/*------------------------------- Constructors -------------------------------*/
  IGList ( );

  IGList ( IGraphic&     graphic  );

  IGList ( const IGList& list     );

virtual
  ~IGList ( );

/*-------------------------------- Drawing -----------------------------------*/
virtual IGList
  &drawOn      ( IGraphicContext& graphicContext );

/*------------------------------ Hit Testing ---------------------------------*/
virtual IGraphic
 *topGraphicUnderPoint    ( const IPoint&    point,
                            IGraphicContext& graphicContext ),

 *bottomGraphicUnderPoint ( const IPoint&    point,
                            IGraphicContext& graphicContext );


class Cursor : public IVBase {
typedef IVBase
  Inherited;

public:
/*------------------------------- Constructors -------------------------------*/
  Cursor ( const IGList&    list             );

  Cursor ( const IGList&    list,
           unsigned long    objectIdentifier );

  Cursor ( const IGList&    list,
           IGraphicContext& graphicContext,
           const IPoint&    hitPoint         );

virtual
 ~Cursor ( );

/*------------------------------ Cursor Positioning --------------------------*/
virtual bool
  setToFirst    ( ),

  setToNext     ( ),

  setToPrevious ( ),

  setToLast     ( ),

  isValid       ( ) const;

virtual void
  invalidate    ( );

private:
/*--------------------------------- Private ----------------------------------*/
const IGList
 *fCursorList;
void
 *fCursor;
enum CursorType {
  regular,
  id,
  hit
  };
CursorType
  fCursorType;
unsigned long
  fId;
IGraphicContext
 *fGc;
ITransformMatrix
 *fCtm,
 *fBtm;
friend class IGList;
        Cursor();
Cursor& operator=(Cursor&);
};


/*------------------------- Adding Graphics Objects --------------------------*/
virtual IGList
  &addAsFirst      ( IGraphic&     graphic ),

  &addAsLast       ( IGraphic&     graphic ),

  &addAsNext       ( const Cursor& cursor,
                     IGraphic&     graphic ),

  &addAsPrevious   ( const Cursor& cursor,
                     IGraphic&     graphic ),

  &addAtPosition   ( unsigned long position,
                     IGraphic&     graphic ),

  &replaceAt       ( const Cursor& cursor,
                     IGraphic&     graphic );


/*------------------------ Removing Graphic Objects --------------------------*/
virtual IGList
  &removeFirst     ( ),

  &removeLast      ( ),

  &removeAtPosition( unsigned long position   ),

  &removeAt        ( const Cursor& cursor     ),

  &removeAll       ( ),

  &removeAllWithId ( unsigned long identifier );


/*---------------------------- Querying the List -----------------------------*/
virtual unsigned long
  numberOfGraphics   ( ) const;

virtual bool
  isEmpty            ( ) const,
  isIGList           ( const Cursor& cursor   ) const;

virtual IGraphic
  *firstGraphic      ( ) const,

  *lastGraphic       ( ) const;

virtual IGraphic
  &graphicAt         ( const Cursor& cursor   ) const,

  &graphicAtPosition ( unsigned long position ) const;

virtual IRectangle
  boundingRectAt     ( const Cursor& cursor   ) const;

/*-------------------------- Reordering the List -----------------------------*/
virtual IGList&
  sort( long (*comparisonFunction)(IGraphic* const& graphic1,
                                   IGraphic* const& graphic2));


private:
/*--------------------------------- Private ----------------------------------*/
friend class IGList::Cursor;
IGList& operator= ( const IGList& );
IGListSeq
 *fList;
}; // IGList

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // IC_PMWIN
#endif // IC_OBSOLETE
#endif // _IGLIST_
