#ifndef _IGLINE_
#define _IGLINE_
/*******************************************************************************
* FILE NAME: igline.hpp                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IGLine                                                                   *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
// Revision: 56 1.2 source/ographic/igline.hpp, graphics, ocdev

#include <ivbase.hpp>

#if ( IC_OBSOLETE <= IC_OBSOLETE_3 )
#ifdef IC_PMWIN

#include <igraphic.hpp>
#include <ipoint.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push, 4)

class IGraphicContext;
class IGraphicBundle;

class IGLine : public IGraphic {
typedef IGraphic
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IGLine    ( const IPoint& startingPoint,
              const IPoint& endingPoint    );

  IGLine    ( const IGLine& line           );

IGLine&
  operator= ( const IGLine& line           );

virtual
  ~IGLine ( );

/*-------------------------------- Drawing -----------------------------------*/
virtual IGLine
  &drawOn          ( IGraphicContext& graphicContext );

/*------------------------------ Data Access ---------------------------------*/
virtual IGLine
  &setStartingPoint ( const IPoint& point ),
  &setEndingPoint   ( const IPoint& point );

virtual IPoint
  startingPoint     ( ) const,
  endingPoint       ( ) const,
  centerPoint       ( ) const;

double
  slope             ( ) const;

/*-------------------------------- Comparison --------------------------------*/
bool
  operator== ( const IGLine& line ) const,
  operator!= ( const IGLine& line ) const;

private:
/*-------------------------------- Private -----------------------------------*/
IPoint
  fStart,
  fEnd;
}; // IGLine

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // IC_PMWIN
#endif // IC_OBSOLETE
#endif // _IGLINE_
