#ifndef _IGELIPSE_
#define _IGELIPSE_
/*******************************************************************************
* FILE NAME: igelipse.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IGEllipse                                                                *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
// Revision: 54 1.2 source/ographic/igelipse.hpp, graphics, ocdev

#include <ivbase.hpp>

#if ( IC_OBSOLETE <= IC_OBSOLETE_3 )
#ifdef IC_PMWIN

#include <igraphic.hpp>
#include <irect.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push, 4)

class IGraphicContext;

class IGEllipse : public IGraphic {
typedef IGraphic
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IGEllipse  ( const IRectangle& rectangle );

  IGEllipse  ( const IPoint&     point,
               unsigned long     radius    );

  IGEllipse  ( const IPoint&     point,
               unsigned long     xRadius,
               unsigned long     yRadius   );

  IGEllipse  ( const IGEllipse&  ellipse   );

IGEllipse
  &operator= ( const IGEllipse&  ellipse   );

virtual
  ~IGEllipse ( );

/*-------------------------------- Drawing -----------------------------------*/
virtual IGEllipse
  &drawOn            ( IGraphicContext& graphicContext );

/*-------------------------- Enclosing Rectangle -----------------------------*/
virtual IGEllipse
  &setEnclosingRect  ( const IRectangle& rectangle );

virtual IRectangle
  enclosingRect      ( ) const;

/*-------------------------------- Comparison --------------------------------*/
bool
  operator== ( const IGEllipse& ellipse ) const,
  operator!= ( const IGEllipse& ellipse ) const;

private:
/*-------------------------------- Private -----------------------------------*/
IRectangle
  fRect;
}; // IGEllipse

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // IC_PMWIN
#endif // IC_OBSOLETE
#endif // _IGELIPSE_
