#ifndef _IGBUNDLE_
#define _IGBUNDLE_
/*******************************************************************************
* FILE NAME: igbundle.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IGraphicBundle                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
// Revision: 77 1.4 source/ographic/igbundle.hpp, graphics, ocdev

#include <ibase.hpp>

#if ( IC_OBSOLETE <= IC_OBSOLETE_3 )
#ifdef IC_PMWIN

#include <ipoint.hpp>
#include <icolor.hpp>
#include <ioldgpl.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push, 4)

class IGraphicContext;

class IGraphicBundle : public IBase {
typedef IBase
  Inherited;

public:
/*------------------------------- Constructors -------------------------------*/
  IGraphicBundle  ( );

  IGraphicBundle  ( const IGraphicBundle&  graphicBundle  );

  IGraphicBundle  ( const IGraphicContext& graphicContext );

IGraphicBundle
  &operator=      ( const IGraphicBundle&  graphicBundle  );

  ~IGraphicBundle ( );

/*---------------------------- Draw Operation --------------------------------*/
enum DrawOperation {
  fill,
  frame,
  fillAndFrame
  };

IGraphicBundle
  &setDrawOperation   ( DrawOperation drawOperation = fillAndFrame );

DrawOperation
  drawOperation       ( ) const;

IGraphicBundle
 &resetDrawOperation  ( );

bool
  hasDrawOperation    ( ) const;

/*---------------------------- Color Attributes ------------------------------*/
IGraphicBundle
  &setPenColor          ( const IColor& penColor  ),
  &setFillColor         ( const IColor& fillColor ),
  &setBackgroundColor   ( const IColor& backColor );

IColor
  penColor              ( ) const,
  fillColor             ( ) const,
  backgroundColor       ( ) const;

IGraphicBundle
  &resetPenColor        ( ),
  &resetFillColor       ( ),
  &resetBackgroundColor ( );

bool
  hasPenColor           ( ) const,
  hasFillColor          ( ) const,
  hasBackgroundColor    ( ) const;

/*---------------------------------- MixMode ---------------------------------*/
enum MixMode {
  bitOr,
  overPaint,
  bitExclusiveOr,
  leaveAlone,
  bitAnd,
  subtract,
  maskSourceNot,
  black,
  notMergeSource,
  notXorSource,
  invert,
  mergeSourceNot,
  notCopySource,
  mergeNotSource,
  notMaskSource,
  white
#if ( IC_OBSOLETE <= IC_OBSOLETE_2 )
#ifndef __DIGRAPHS__
  ,
  or  = bitOr,
  xor = bitExclusiveOr,
  and = bitAnd
#endif
#endif
  };

IGraphicBundle
 &setMixMode           ( MixMode mixMode = overPaint );

MixMode
  mixMode              ( ) const;

IGraphicBundle
 &resetMixMode         ( );

bool
  hasMixMode           ( ) const;

/*---------------------------- BackgroundMixMode -----------------------------*/
enum BackgroundMixMode {
  backLeaveAlone,
  backOverPaint,
  backOr,
  backXor
  };

IGraphicBundle
 &setBackgroundMixMode   ( BackgroundMixMode backgroundMixMode =
                                                               backLeaveAlone );
BackgroundMixMode
  backgroundMixMode      ( ) const;

IGraphicBundle
 &resetBackgroundMixMode ( );

bool
  hasBackgroundMixMode   ( ) const;

/*----------------------------- Pen Width ------------------------------------*/
IGraphicBundle
 &setPenWidth            ( unsigned long lineWidth = 1 );

unsigned long
  penWidth               ( ) const;

IGraphicBundle
 &resetPenWidth          ( );

bool
  hasPenWidth            ( ) const;

/*------------------------------ Pen Type ------------------------------------*/
enum PenType {
  solid,
  dot,
  shortDash,
  dashDot,
  doubleDot,
  longDash,
  dashDoubleDot,
  alternate,
  invisible
  };

IGraphicBundle
  &setPenType              ( PenType penType = solid );

PenType
  penType                  ( ) const;

IGraphicBundle
 &resetPenType             ( );

bool
  hasPenType               ( ) const;

/*------------------------------ PenEndingStyle ------------------------------*/
enum PenEndingStyle {
  flat,
  square,
  rounded
  };

IGraphicBundle
 &setPenEndingStyle        ( PenEndingStyle penEndingStyle = flat );

PenEndingStyle
  penEndingStyle           ( ) const;

IGraphicBundle
 &resetPenEndingStyle      ( );

bool
  hasPenEndingStyle        ( ) const;


/*------------------------------ PenJoiningStyle -----------------------------*/
enum PenJoiningStyle {
  bevel,
  round,
  miter
  };

IGraphicBundle
  &setPenJoiningStyle      ( PenJoiningStyle penJoiningStyle = bevel );

PenJoiningStyle
  penJoiningStyle          ( ) const;

IGraphicBundle
 &resetPenJoiningStyle     ( );

bool
  hasPenJoiningStyle       ( ) const;

/*--------------------------- Pen and Fill Patterns --------------------------*/
static const unsigned long
  IC_IMPORTFG dense1,
  IC_IMPORTFG dense2,
  IC_IMPORTFG dense3,
  IC_IMPORTFG dense4,
  IC_IMPORTFG dense5,
  IC_IMPORTFG dense6,
  IC_IMPORTFG dense7,
  IC_IMPORTFG dense8,
  IC_IMPORTFG vertical,
  IC_IMPORTFG horizontal,
  IC_IMPORTFG forewardDiag1,
  IC_IMPORTFG forewardDiag2,
  IC_IMPORTFG backwardDiag1,
  IC_IMPORTFG backwardDiag2,
  IC_IMPORTFG hollow,
  IC_IMPORTFG filled,
  IC_IMPORTFG halftone,
  IC_IMPORTFG hatched,
  IC_IMPORTFG hatchedDiag;

IGraphicBundle
  &setPenPattern           ( unsigned long penPattern  = filled ),
  &setFillPattern          ( unsigned long fillPattern = filled );

//  &setPattern            ( const IBitmapHandle& handle       );

unsigned long
  penPattern               ( ) const,
  fillPattern              ( ) const;

IGraphicBundle
 &resetPenPattern          ( ),
 &resetFillPattern         ( );

bool
  hasPenPattern            ( ) const,
  hasFillPattern           ( ) const;

/*--------------------------- Pattern Origin ---------------------------------*/
IGraphicBundle
 &setPatternOrigin        ( const IPoint& point = IPoint(0,0) );

IPoint
  patternOrigin           ( ) const;

IGraphicBundle
 &resetPatternOrigin      ( );

bool
  hasPatternOrigin        ( ) const;

/*------------------------------ Comparison ----------------------------------*/
bool
  operator== ( const IGraphicBundle& graphicBundle ),
  operator!= ( const IGraphicBundle& graphicBundle );

private:
/*--------------------------------- Private ----------------------------------*/
enum Attribute {
  pColor = 0x0001,
  fColor = 0x0002,
  bColor = 0x0004,
  pMix   = 0x0008,
  bMix   = 0x0010,
  pWidth = 0x0020,
  pType  = 0x0040,
  pEnd   = 0x0080,
  pJoin  = 0x0100,
  pPat   = 0x0200,
  fPat   = 0x0400,
  pOrg   = 0x0800,
  drawOp = 0x1000,
  All    = 0x1fff
  };

IColor
  fPen,
  fFill,
  fBack;
DrawOperation
  fDrawOp;
MixMode
  fPmix;
BackgroundMixMode
  fBmix;
unsigned long
  fPpat,
  fFpat;
PenType
  fPtype;
PenEndingStyle
  fPend;
PenJoiningStyle
  fPjoin;
unsigned long
  fWidth;
IPoint
  fOrg;
unsigned long
  fMask;

}; // IGraphicBundle

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

/*--------------------------------- INLINES ----------------------------------*/
#include <igbundle.inl>

#endif // IC_PMWIN
#endif // IC_OBSOLETE
#endif // _IGBUNDLE_
