#ifndef _IGBITMAP_
#define _IGBITMAP_
/*******************************************************************************
* FILE NAME: igbitmap.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IGBitmap                                                                 *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
// Revision: 49 1.3 source/ographic/igbitmap.hpp, graphics, ocdev

#include <ivbase.hpp>

#if ( IC_OBSOLETE <= IC_OBSOLETE_3 )
#ifdef IC_PMWIN

#include <igraphic.hpp>
#include <ihandle.hpp>
#include <ipoint.hpp>
#include <icolor.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push, 4)

class IString;
class IGraphicContext;
class IResourceId;
class IGBitmapData;
struct _MOD;

class IGBitmap : public IGraphic {
typedef IGraphic
  Inherited;

public:

enum ImageFormat {
  Bitmap,
  GIF,
  PCX,
  TIFF,
  Targa,
  Amiga,
  XBM,
  PSEG
  };

/*------------------------------- Constructors -------------------------------*/
  IGBitmap  ( const IBitmapHandle&   bitmapHandle           );

  IGBitmap  ( unsigned long          bitmapIdentifier,
              bool         useColorData = false   );

  IGBitmap  ( const IResourceId&     resourceIdentifier,
              bool         useColorData = false   );

  IGBitmap  ( const IString&         imageFilename          );

  IGBitmap  ( const IString&         imageFilename,
              ImageFormat            imageFormat            );

  IGBitmap  ( const IGraphicContext& graphicContext,
              const IRectangle&      windowRectangle        );

  IGBitmap  ( const IGBitmap&        bitmap,
              const IRectangle&      rectangle,
              long                   rasterOperation = normal );

virtual
  ~IGBitmap ( );

/*----------------------- Common Raster Operations ---------------------------*/
static const long
  IC_IMPORTFG black,
  IC_IMPORTFG notSourceErase,
  IC_IMPORTFG halftone,
  IC_IMPORTFG invert,
  IC_IMPORTFG sourceErase,
  IC_IMPORTFG destInvert,
  IC_IMPORTFG patternInvert,
  IC_IMPORTFG sourceInvert,
  IC_IMPORTFG sourceAnd,
  IC_IMPORTFG mergePaint,
  IC_IMPORTFG mergeCopy,
  IC_IMPORTFG normal,
  IC_IMPORTFG sourcePaint,
  IC_IMPORTFG patternCopy,
  IC_IMPORTFG patternPaint,
  IC_IMPORTFG white;

/*------------------------------ Compress Mode -------------------------------*/
enum CompressMode {
  bitAnd,
  bitOr,
  ignore
#if ( IC_OBSOLETE <= IC_OBSOLETE_2 )
#ifndef __DIGRAPHS__
  ,
  or  = bitOr,
  and = bitAnd
#endif
#endif
  };

/*-------------------------------- Drawing -----------------------------------*/
virtual IGBitmap
  &drawOn              ( IGraphicContext& graphicContext            ),

  &drawOn              ( IGraphicContext& graphicContext,
                         long             rasterOperation           ),

  &drawOn              ( IGraphicContext& graphicContext,
                         const IPoint&    targetBottomLeft,
                         const IPoint&    targetTopRight,
                         const IPoint&    sourceBottomLeft,
                         const IPoint&    sourceTopRight,
                         long             rasterOperation = normal,
                         CompressMode     compressMode    = ignore  );

/*--------------------------- Writing To A File ------------------------------*/
virtual IGBitmap
  &writeToFile         ( const IString& imageFilename,
                         ImageFormat    imageFormat            );

virtual ImageFormat
  imageFormat          ( ) const;

/*--------------------------- Bitmap Positioning -----------------------------*/
virtual IGBitmap
  &moveTo              ( const IPoint& point   ),
  &sizeTo              ( const ISize&  newSize );

virtual ISize
  size                 ( ) const;
virtual IPoint
  position             ( ) const;

/*-------------------------- Modifying The Bitmap ----------------------------*/
virtual IGBitmap
  &reflectHorizontally ( ),
  &reflectVertically   ( ),
  &transposeXForY      ( ),
  &rotateBy90          ( ),
  &rotateBy180         ( ),
  &rotateBy270         ( );

/*------------------------------- View Option --------------------------------*/
enum ViewOption {
  raw,
  errorDiffused,
  halftoned
  };

virtual IGBitmap
  &setViewOption       ( ViewOption viewOption = raw );
virtual ViewOption
  viewOption           ( ) const;


/*--------------------------- Bitmap Transparency ----------------------------*/
virtual IGBitmap
  &setTransparentColor   ( const IColor& aColor ),
  &resetTransparentColor ( );

virtual IColor
  transparentColor       ( ) const;

virtual bool
  hasTransparentColor    ( ) const;

/*----------------------------- Bitmap Palette -------------------------------*/
unsigned long
  setPalette             ( unsigned long palette );

unsigned long
  palette                ( ) const;

/*-------------------------------- Accessors ---------------------------------*/
virtual IBitmapHandle
  handle               ( ) const;

virtual IPointerHandle
  asPointerHandle      ( ) const;

/*----------------------------- Bitmap Copying -------------------------------*/
static IBitmapHandle
  copy                   ( const IBitmapHandle& bitmapHandle );

protected:
/*---------------------------- Loading a Bitmap ------------------------------*/
static unsigned long
  loadBitmap           ( unsigned long        bitmapIdentifier,
                         const IModuleHandle& moduleHandle,
                         const ISize&         bitmapSize = ISize(0,0) ),
  tryToLoadBitmap      ( unsigned long        bitmapIdentifier,
                         const IModuleHandle& moduleHandle,
                         const ISize&         bitmapSize = ISize(0,0) );

private:
/*------------------------------ Hidden Members ------------------------------*/
  IGBitmap    ( const IGBitmap& bitmap );
IGBitmap
 &operator=   ( const IGBitmap& bitmap );

/*--------------------------------- Private ----------------------------------*/
friend class IResourceLibrary;
static unsigned long
  copyBitmap(IGraphicContext&, unsigned long, const ISize&);
IGBitmap
  &modReflect  ( int (* _Optlink reflector)(_MOD*, _MOD*) ),
  &loadFromFile( const IString&    filename,
                 int               ft             ),
  &draw        ( IGraphicContext&, long, void *   );
static int
  ft( const ImageFormat& imageFormat );
void
  createMask();
IBitmapHandle
  fBitmap,
  fMask;
IPoint
  fPos;
IColor*
  fTransparent;
ViewOption
  fVo;
ImageFormat
  fIf;
struct _MOD*
  fMod;

IGBitmapData
 *fGBitmapData;
};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // IC_PMWIN
#endif // IC_OBSOLETE
#endif // _IGBITMAP_
