#ifndef _IGARC_
#define _IGARC_
/*******************************************************************************
* FILE NAME: igarc.hpp                                                         *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IGArc                                                                    *
*     IG3PointArc                                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
// Revision: 48 1.2 source/ographic/igarc.hpp, graphics, ocdev

#include <ivbase.hpp>

#if ( IC_OBSOLETE <= IC_OBSOLETE_3 )
#ifdef IC_PMWIN

#include <igraphic.hpp>
#include <ipoint.hpp>
#include <irect.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push, 4)

class IGraphicContext;


class IGArc : public IGraphic {
typedef IGraphic
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IGArc     ( const IRectangle& rectangle,
              double            startAngle,
              double            sweepAngle );

  IGArc     ( const IGArc&      arc        );

IGArc&
  operator= ( const IGArc&      arc        );

virtual
  ~IGArc    ( );

/*-------------------------------- Drawing -----------------------------------*/
virtual IGArc
  &drawOn           ( IGraphicContext& graphicContext );

/*-------------------------- Enclosing Rectangle -----------------------------*/
virtual IGArc
  &setEnclosingRect     ( const IRectangle& rectangle );

virtual IRectangle
  enclosingRect         ( ) const;

/*----------------------- Start and Sweep Angles -----------------------------*/
virtual IGArc
  &setStartAngle    ( double startAngle ),
  &setSweepAngle    ( double sweepAngle );

virtual double
  startAngle        ( ) const,
  sweepAngle        ( ) const;

/*-------------------------------- Direction ---------------------------------*/
enum Direction {
  clockwise,
  counterclockwise
  };

virtual IGArc
  &setDirection     ( Direction direction = counterclockwise );

virtual Direction
  direction         ( ) const;

/*-------------------------------- Comparison --------------------------------*/
bool
  operator==        ( const IGArc& arc ) const,
  operator!=        ( const IGArc& arc ) const;

private:
/*-------------------------------- Private -----------------------------------*/

IRectangle
  fRect;
double
  fStart,
  fSweep;
Direction
  fAd;
}; // IGArc

class IG3PointArc : public IGraphic {
typedef IGraphic
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IG3PointArc( const IPoint& starting,
               const IPoint& intermediate,
               const IPoint& ending        );

  IG3PointArc( const IG3PointArc& arc      );

IG3PointArc&
  operator=  ( const IG3PointArc& arc      );

virtual
  ~IG3PointArc( );

/*-------------------------------- Drawing -----------------------------------*/
virtual IG3PointArc
  &drawOn           ( IGraphicContext& graphicContext );

/*-------------------------------- Data Access -------------------------------*/
virtual IG3PointArc
  &setStartingPoint      ( const IPoint& point ),
  &setIntermediatePoint  ( const IPoint& point ),
  &setEndingPoint        ( const IPoint& point );

virtual IPoint
  startingPoint          ( ) const,
  intermediatePoint      ( ) const,
  endingPoint            ( ) const;

/*-------------------------------- Comparison --------------------------------*/
bool
  operator== ( const IG3PointArc& arc ) const,
  operator!= ( const IG3PointArc& arc ) const;

private:
/*-------------------------------- Private -----------------------------------*/

IPoint
  fStart,
  fIntermediate,
  fEnd;
}; // IG3PointArc

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // IC_PMWIN
#endif // IC_OBSOLETE
#endif // _IGARC_
