// Revision: 46 1.4.1.4 source/ui/baseapp/iframhdr.hpp, frame, ioc.v400, 980918 
#ifndef _IFRAMHDR_
#define _IFRAMHDR_
/*******************************************************************************
* FILE NAME: iframhdr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the declarations of the classes:                        *
*     IFrameHandler                                                            *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <ihandler.hpp>
#include <iframevt.hpp>
#include <icmdevt.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IFrameWindow;

#pragma enum(4)
#pragma pack(push,4)

class IFrameHandler : public IHandler {
typedef IHandler
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IFrameHandler ( );

virtual
 ~IFrameHandler ( );

/*----------------------------- Frame Extensions -----------------------------*/
virtual unsigned long
  numberOfExtensions ( const IFrameWindow* frame ) const;

/*----------------------------- Event Processing -----------------------------*/
virtual bool
#ifndef IC_MOTIF_FLAGNOP
  deactivated ( IFrameEvent&       frameEvent  ),
#endif
  draw        ( IFrameEvent&       frameEvent  ),
  format      ( IFrameFormatEvent& formatEvent ),
  closed      ( IFrameEvent&       frameEvent  ),
  activated   ( IFrameEvent&       frameEvent  ),
  saved       ( IFrameEvent&       frameEvent  ),
  command     ( ICommandEvent&     cmdEvent    ),
  calcRect    ( IFrameEvent&       frameEvent  );

protected:
/*---------------------------- Event Dispatching -----------------------------*/
virtual bool
  dispatchHandlerEvent ( IEvent& event );

/*----------------------------- Frame Extensions -----------------------------*/
#ifndef IC_MOTIF_FLAGNOP
virtual unsigned long
  positionExtensions ( IFrameFormatEvent& formatEvent,
                       unsigned long      numStdControls );
#endif
}; // IFrameHandler

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _IFRAMHDR_ */
