// Revision: 43 1.9.1.4 source/ui/baseapp/iframext.hpp, frame, ioc.v400, 980918 
#ifndef _IFRAMEXT_
#define _IFRAMEXT_
/*******************************************************************************
* FILE NAME: iframext.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IFrameExtension                                                          *
*     IFrameExtensions                                                         *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>
#include <iframe.hpp>
#include <ipoint.hpp>
#include <irect.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IFrameExtensionData;
class IFrameExtensionsImp;
class IPresSpaceHandle;
class ISWP;

#pragma enum(4)
#pragma pack(push,4)

class IFrameExtension  {
public:
/*------------------------------- Constructors -------------------------------*/
  IFrameExtension ( IWindow*                     window,
                    IFrameWindow::Location       location,
                    unsigned long                widthOrHeight,
                    IFrameWindow::SeparatorType  separator );
  IFrameExtension ( IWindow*                     window,
                    IFrameWindow::Location       location,
                    double                       percentage,
                    IFrameWindow::SeparatorType  separator );
  IFrameExtension ( IWindow*                     window,
                    IFrameWindow::Location       location,
                    IFrameWindow::SeparatorType  separator );
 ~IFrameExtension ( );

/*----------------------------- Extension Window -----------------------------*/
IWindow
 *control ( ) const;

/*------------------------------ Extension Type ------------------------------*/
enum Type {
  fixed,
  relative,
  minimumSize
  };

Type
  type ( ) const;

/*----------------------------- Extension Sizing -----------------------------*/
virtual unsigned long
  fixedSize      ( ) const;

virtual double
  relativeSize   ( ) const;

virtual IFrameExtension
 &setSize        ( unsigned long     widthOrHeight ),
 &setSize        ( int               widthOrHeight ),
 &setSize        ( double            widthOrHeight );

virtual ISize
  sizeTo         ( const ISize&      baseSize ) const;

virtual IRectangle
  totalRectFor   ( const IRectangle& baseRect ) const,
  baseRectFor    ( const IRectangle& totalRect ) const;

#ifndef IC_MOTIF_FLAGNOP
virtual IFrameExtension
 &useMinimumSize ( );
#endif

/*---------------------------- Extension Location ----------------------------*/
IFrameWindow::Location
  location     ( ) const;

#ifndef IC_MOTIF_FLAGNOP
virtual ISWP
  attachTo     ( ISWP& baseSWP );
#endif

virtual unsigned long
  attachedToId ( ) const;

/*-------------------------------- Separator ---------------------------------*/
virtual unsigned long
  separatorWidth ( ) const;

#ifndef IC_MOTIF_FLAGNOP
virtual void
  drawSeparator  ( const IPresSpaceHandle& psh );
#endif

private:
/*--------------------------------- Private ----------------------------------*/
IFrameExtensionData
 *pData;

IFrameWindow::Location
  mappedLocation ( ) const;

union {
  double
    extRelativeSize;
  unsigned long
    extFixedSize;
  };

Type
  extType;
IFrameWindow::Location
  extLocation;
IFrameWindow::SeparatorType
  extSeparator;
IPoint
  extPosition;
ISize
  extSize;
IWindow
 *extControl;

/*------------------------------ Hidden Members ------------------------------*/
IFrameExtension ( const IFrameExtension& frameExtension );
IFrameExtension
 &operator =    ( const IFrameExtension& frameExtension );
}; // IFrameExtension


class IFrameExtensions {
public:
/*------------------------------- Constructors -------------------------------*/
  IFrameExtensions ( );
 ~IFrameExtensions ( );

  class Cursor {
  public:
    Cursor ( const IFrameExtensions& extensions );
   ~Cursor ( );

  bool
    setToFirst    ( ),
    setToLast     ( ),
    setToNext     ( ),
    setToPrevious ( ),
    isValid       ( ) const;

  void
    invalidate ( );

  IFrameExtension* const
    element    ( ) const;

  private:
  const IFrameExtensionsImp
   *fExtensionsImp;
  void
   *fExtensionsCursorImp;

    Cursor    ( const Cursor& cursor);
  Cursor
   &operator= ( const Cursor& cursor );

  friend class IFrameExtensions;
  }; // IFrameExtensions::Cursor

bool
  add           ( IFrameExtension* const& extension);

void
  addAsLast     ( IFrameExtension* const& extension ),
  addAsFirst    ( IFrameExtension* const& extension ),
  addAsNext     ( IFrameExtension* const& extension,
                  Cursor&                 cursor ),
  addAtPosition ( unsigned long           pos,
                  IFrameExtension* const& extension ),
  addAsPrevious ( IFrameExtension* const& extension,
                  Cursor&                 cursor );

IFrameExtension
 *elementAt     ( const Cursor& cursor ) const;

IFrameExtension
 *elementAtPosition ( unsigned long position ) const,
 *firstElement      ( ) const,
 *lastElement       ( ) const;

bool
  isEmpty ( ) const;

unsigned long
  position         ( Cursor const& cursor ) const,
  numberOfElements ( ) const,
  removeAll        ( );

void
  removeAt         ( Cursor&                 cursor ),
  removeAtPosition ( unsigned long           position ),
  removeFirst      ( ),
  removeLast       ( ),
  replaceAt        ( const Cursor&           cursor,
                     IFrameExtension* const& extension ),
  setToPosition    ( unsigned long           pos,
                     Cursor&                 cursor) const;

private:
/*--------------------------------- Private ----------------------------------*/
friend class Cursor;
IFrameExtensionsImp
 *fExtensionsImp;

/*------------------------------ Hidden Members ------------------------------*/
  IFrameExtensions ( const IFrameExtensions& );
IFrameExtensions
 &operator=        ( const IFrameExtensions& );
}; // IFrameExtensions

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <iframext.inl>

#endif /* _IFRAMEXT_ */
