// Revision: 40 1.6.1.3 source/ui/baseapp/iframevt.hpp, frame, ioc.v400, 980918 
#ifndef _IFRAMEVT_
#define _IFRAMEVT_
/*******************************************************************************
* FILE NAME: iframevt.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the declarations of the classes:                        *
*     IFrameEvent                                                              *
*     IFrameFormatEvent                                                        *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <ievent.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IFrameWindow;
class IRectangle;
class ISWP;

#pragma enum(4)
#pragma pack(push,4)

class IFrameEvent : public IEvent {
typedef IEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IFrameEvent ( const IEvent&      baseEvent );
  IFrameEvent ( const IFrameEvent& frameEvent );
IFrameEvent
 &operator=   ( const IFrameEvent& frameEvent );

 ~IFrameEvent ( );

/*------------------------------- Frame Window -------------------------------*/
IFrameWindow
 *frame ( ) const;

private:
/*--------------------------------- Private ----------------------------------*/
IFrameWindow
 *pFrame;
}; // IFrameEvent

class IFrameFormatEvent : public IFrameEvent {
typedef IFrameEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IFrameFormatEvent ( const IEvent&            baseEvent );
  IFrameFormatEvent ( const IFrameFormatEvent& fmtEvent );
 ~IFrameFormatEvent ( );

/*-------------------------- Formatting Information --------------------------*/
ISWP
 *swpArray      ( ) const;

IRectangle
  clientRect    ( ) const;

IFrameFormatEvent
 &setClientRect ( const IRectangle& rectangle );
}; // IFrameFormatEvent

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <iframevt.inl>

#endif /* _IFRAMEVT_ */
