// Revision: 37 1.20.1.12 source/ui/baseapp/iframe.hpp, frame, ioc.v400, 980918 
#ifndef _IFRAME_
#define _IFRAME_
/*******************************************************************************
* FILE NAME: iframe.hpp                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the declarations of the classes:                        *
*     IFrameWindow                                                             *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
#include <iwindow.hpp>
#include <icconst.h>
#include <icmdevt.hpp>
#include <ihandle.hpp>
#include <irect.hpp>
#include <ireslib.hpp>
#ifdef IC_MOTIF
  #include <iarglist.hpp>
#endif

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IColor;
class IColorMap;
class IFont;
class IFrameExtension;
class IFrameExtensions;
class IFrameHandler;
class IFrameWindowData;
class IFrameWindowNotifyHandler;
class IToolBarList;

#pragma enum(4)
#pragma pack(push,4)

class IFrameWindow : public IWindow {
typedef IWindow
  Inherited;
public:
class Style;
enum FrameSource {
  dialogResource,
  noDialogResource,
  tryDialogResource
  };
/*------------------------------- Constructors -------------------------------*/
  IFrameWindow ( unsigned long      id = IC_DEFAULT_FRAME_ID,
                 FrameSource        source = tryDialogResource );

  IFrameWindow ( const IResourceId& resId,
                 IWindow*           owner = 0,
                 FrameSource        source = tryDialogResource );

  IFrameWindow ( const IResourceId& resId,
                 IWindow*           parent,
                 IWindow*           owner,
                 FrameSource        source = tryDialogResource );

#ifdef IC_PMWIN
  IFrameWindow ( const IWindowHandle& hwnd );
#endif

  IFrameWindow ( const IResourceId&         resId,
                 const IFrameWindow::Style& style );

  IFrameWindow ( const IFrameWindow::Style& style,
                 const IResourceId&         resId = IC_DEFAULT_FRAME_ID );

  IFrameWindow ( const char*                title,
                 const IResourceId&         resId = IC_DEFAULT_FRAME_ID,
                 const IFrameWindow::Style& style = defaultStyle() );

  IFrameWindow ( const IResourceId&         resId,
                 IWindow*                   parent,
                 IWindow*                   owner ,
                 const IRectangle&          initRect,
                 const IFrameWindow::Style& style = defaultStyle(),
                 const char*                title = 0 );

virtual
 ~IFrameWindow ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF1( Style, IFrameWindow, IWindow );

static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU accelerator,
  IC_IMPORTU alignNoAdjust,
#ifndef IC_MOTIFWIN_FLAGNOP
  IC_IMPORTU animated,
  IC_IMPORTU appDBCSStatus,
#endif
  IC_IMPORTU border,
  IC_IMPORTU dialogBackground,
  IC_IMPORTU dialogBorder,
#ifndef IC_MOTIFWIN_FLAGNOP
  IC_IMPORTU hideButton,
#endif
  IC_IMPORTU horizontalScroll,
  IC_IMPORTU maximizeButton,
  IC_IMPORTU maximized,
  IC_IMPORTU menuBar,
  IC_IMPORTU minimizeButton,
  IC_IMPORTU minimized,
  IC_IMPORTU minimizedIcon,
#ifndef IC_MOTIFWIN_FLAGNOP
  IC_IMPORTU noMoveWithOwner,
#endif
  IC_IMPORTU shellPosition,
  IC_IMPORTU sizingBorder,
  IC_IMPORTU systemMenu,
#ifndef IC_MOTIFWIN_FLAGNOP
  IC_IMPORTU systemModal,
#endif
  IC_IMPORTU titleBar,
  IC_IMPORTU verticalScroll,
  IC_IMPORTU windowList;

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

//#ifdef IC_PMWIN
virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      bool            extendedOnly = false ) const;
//#endif
#ifdef IC_MOTIF
virtual IArgList
  convertToArgList ( const IBitFlag& style ) const;
#endif

/*----------------------- System-Menu-Related Actions ------------------------*/
virtual IFrameWindow
 &close          ( ),
#ifndef IC_MOTIF_FLAGNOP
 &maximize       ( ),
 &restore        ( ),
 &setRestoreRect ( const IRectangle& rect ),
#endif
 &minimize       ( );

#ifndef IC_MOTIF_FLAGNOP
virtual IRectangle
  maximizeRect  ( ) const,
  minimizeRect  ( ) const,
  restoreRect   ( ) const;
#endif

static IRectangle
  nextShellRect ( );

/*---------------------------- Moving and Sizing -----------------------------*/
virtual IFrameWindow
 &moveSizeToClient ( const IRectangle& clientRect );

virtual IRectangle
  clientRectFor    ( const IRectangle& frameRect ) const,
  frameRectFor     ( const IRectangle& clientRect ) const;


virtual IFrameWindow
 &setMaximumFrameSize ( const ISize& maximumFrameSize ),
 &setMinimumFrameSize ( const ISize& minimumFrameSize );

virtual ISize
  maximumFrameSize  ( ) const,
  minimumFrameSize  ( ) const;

/*------------------------------- Border Size --------------------------------*/
#ifndef IC_MOTIF_FLAGNOP
unsigned long
  borderWidth     ( ) const,
  borderHeight    ( ) const;

ISize
  borderSize      ( ) const;
#endif

#ifndef IC_MOTIFWIN_FLAGNOP
IFrameWindow
 &setBorderWidth  ( unsigned long cx ),
 &setBorderHeight ( unsigned long cy ),
 &setBorderSize   ( const ISize&  size ),
 &setBorderSize   ( unsigned long cxcy ),
 &setBorderSize   ( unsigned long cx,
                    unsigned long cy );
#endif

/*------------------------------ Modal Display -------------------------------*/
virtual unsigned long
  showModally ( ),
  result      ( ) const;

virtual IFrameWindow
 &dismiss     ( unsigned long result = 0 ),
 &setResult   ( unsigned long result ),

 &notifyOwner ( unsigned long         id,
                ICommandEvent::Source source = ICommandEvent::unknown,
                bool                  pointerDevice = false );

/*----------------------------- Application Icon -----------------------------*/
virtual IPointerHandle
  icon    ( ) const;

virtual IFrameWindow
 &setIcon ( const IPointerHandle& icon ),
 &setIcon ( const IResourceId&    iconResId ),
 &setIcon ( unsigned long         iconResId );

/*--------------------------------- Colors -----------------------------------*/
#ifndef IC_MOTIFWIN_FLAGNOP
virtual IColor
  backgroundColor              ( ) const;
#endif //!IC_WIN_FLAGNOP

#ifndef IC_MOTIFWIN_FLAGNOP
virtual IColor
  disabledBackgroundColor      ( ) const;
#endif //!IC_MOTIFWIN_FLAGNOP

#ifndef IC_MOTIFWIN_FLAGNOP
virtual IFrameWindow
 &resetBackgroundColor         ( ),
 &resetDisabledBackgroundColor ( );
#endif //!IC_MOTIFWIN_FLAGNOP

#ifndef IC_MOTIF_FLAGNOP
bool
  usesDialogBackground         ( ) const;
#endif

virtual IFrameWindow
 &setColorMap                  ( IColorMap* colorMap);
IColorMap
 *colorMap                     ( ) const;


#ifdef IC_WIN
/*------------------------------ Font Functions ------------------------------*/
virtual IWindow
 &setFont      ( const IFont& font );
#endif

/*------------------------------ Client Window -------------------------------*/
virtual IWindowHandle
  clientHandle ( ) const;

virtual IWindow
 *client       ( ) const;

virtual IFrameWindow
 &setClient    ( IWindow* newClient );

/*----------------------------- Frame Extensions -----------------------------*/
enum Location {
#ifndef IC_MOTIFWIN_FLAGNOP
  leftOfTitleBar,
  rightOfTitleBar,
  leftOfMenuBar,
  rightOfMenuBar,
#endif
  leftOfClient,
  rightOfClient,
  aboveClient,
  belowClient
  };

enum SeparatorType {
  none,
  thinLine,
  thickLine
  };

virtual IFrameWindow
 &addExtension     ( IWindow*      newExtension,
                     Location      location,
                     unsigned long widthOrHeight,
                     SeparatorType separator = thinLine ),
 &addExtension     ( IWindow*      newExtension,
                     Location      location,
                     int           widthOrHeight,
                     SeparatorType separator = thinLine ),
 &addExtension     ( IWindow*      newExtension,
                     Location      location,
                     double        percentage,
                     SeparatorType separator = thinLine ),
 &addExtension     ( IWindow*      newExtension,
                     Location      location,
                     SeparatorType separator = thinLine ),

 &removeExtension  ( IWindow*      extension,
                     bool          updateDisplay = true ),

 &setExtensionSize ( IWindow*      extension,
                     unsigned long widthOrHeight ),
 &setExtensionSize ( IWindow*      extension,
                     int           widthOrHeight ),
 &setExtensionSize ( IWindow*      extension,
                     double        widthOrHeight ),
 &useExtensionMinimumSize ( IWindow* extension ),

 &update           ( bool          forceUpdate = false );

virtual bool
  isAnExtension    ( const IWindow* window ) const;

/*------------------------------ Window Display ------------------------------*/
virtual IFrameWindow
 &show ( bool showWindow = true );

/*---------------------------- Window Destruction ----------------------------*/
virtual IFrameWindow
 &setDestroyOnClose  ( bool destroy = true );

bool
  willDestroyOnClose ( ) const;

/*--------------------------------- Testing ----------------------------------*/
bool
#ifndef IC_MOTIF_FLAGNOP
  isFlashing  ( ) const,
  isMaximized ( ) const,
#endif
  isMinimized ( ) const,
  isModal     ( ) const;

/*------------------------------- Window List --------------------------------*/
#ifndef IC_MOTIF_FLAGNOP
virtual IFrameWindow
 &addToWindowList      ( ),
 &removeFromWindowList ( );
#endif

/*------------------------- Standard Control Access --------------------------*/
virtual IWindowHandle
  handleFor ( const Style& standardControl ) const;

/*----------------------------- Window Flashing ------------------------------*/
#ifndef IC_MOTIF_FLAGNOP
virtual IFrameWindow
 &beginFlashing ( ),
 &endFlashing   ( );

#ifdef IC_PM
/*------------------------------- DBCS Support -------------------------------*/
virtual IFrameWindow
 &shareParentDBCSStatus ( );
#endif
#endif

/*------------------------------ Sibling Order -------------------------------*/
static void
  setDefaultOrdering ( IWindow::SiblingOrder ordering );
static IWindow::SiblingOrder
  defaultOrdering    ( );

/*------------------------------ Window Layout -------------------------------*/
IFrameWindow
 &setLayoutDistorted ( unsigned long layoutAttributesOn,
                       unsigned long layoutAttributesOff );

/*------------------------- Dialog Behavior Support --------------------------*/
virtual IWindowHandle
  defaultPushButton     ( ) const,
  defaultEmphasisButton ( ) const,
  matchForMnemonic      ( unsigned short character ) const;

/*---------------------------- Title Support ---------------------------------*/
virtual IFrameWindow
 &setTitleText ( const char*        titleText ),
 &setTitleText ( const IResourceId& titleResId );
virtual IString
  titleText    ( ) const;

/*--------------------- Notification Event Descriptions ----------------------*/
static INotificationId const
  IC_IMPORTU closeId,
  IC_IMPORTU activateId,
  IC_IMPORTU deactivateId,
  IC_IMPORTU titleTextId;

/*-------------------------- Observer Notification ---------------------------*/
virtual IFrameWindow
 &enableNotification ( bool enable = true );

/*----------------------------- Tool Bar Support -----------------------------*/
IFrameWindow
 &setToolBarList ( IToolBarList* toolBarList );
IToolBarList
 *toolBarList    ( ) const;

/*-------------------------------- Attributes --------------------------------*/
#ifdef IC_MOTIF
virtual IWindowHandle
  handleForChildCreation( ) const;
#endif

protected:
/*----------------------- Frame Extensions Management ------------------------*/
IFrameExtensions
 *extensions    ( ) const;

unsigned
  findExtension ( IWindow* window );

IFrameWindow
 &setExtensions ( IFrameExtensions* extensions );

#ifdef IC_PMWIN
/*---------------------- Bidirectional Language Support ----------------------*/
virtual IFrameWindow
 &setBidiSettings ( const IBidiSettings& bidiSettings,
                    bool                 childInherit,
                    bool                 refresh );
#endif

/*------------------------------ Implementation ------------------------------*/
static const Style
  IC_IMPORTU deferCreation;

IFrameWindow
 &tryToLoadDialog ( const IResourceId& resId,
                    IWindow*           parent = 0,
                    IWindow*           owner  = 0,
                    FrameSource        source = tryDialogResource );

#ifndef IC_MOTIF_FLAGNOP
IFrameWindow
 &initialize      ( const IResourceId& resId,
                    const Style&       style,
                    IWindow*           parent   = 0,
                    IWindow*           owner    = 0,
                    const IRectangle&  initRect = nextShellRect(),
                    const char*        title    = 0 );
#endif
#ifdef  IC_MOTIF_FLAGNOP
IFrameWindow
 &initialize      ( const IResourceId& resId,
                    const Style&       style,
                    IWindow*           parent   = 0,
                    IWindow*           owner    = 0,
                    const IRectangle&  initRect = IRectangle(),
                    const char*        title    = 0 );
#endif

#ifdef IC_WIN
unsigned long
  registerFrameClass ( const Style&       style,
                       const IResourceId& resId );
#endif

#ifdef IC_PMWIN
IWindowHandle
  create ( unsigned long         id,
           const char*           title,
           unsigned long         style,
           const char*           windowClass,
           const IWindowHandle&  parent,
           const IWindowHandle&  owner,
           const IRectangle&     initRect,
           const void*           ctlData,
           const void*           presParams,
           IWindow::SiblingOrder ordering = defaultOrdering(),
           unsigned long         extendedStyle = 0 );
IWindowHandle
  create ( unsigned long         id,
           const char*           title,
           const IBitFlag&       style,
           const char*           windowClass,
           const IWindow*        parent,
           const IWindow*        owner,
           const IRectangle&     initRect,
           const void*           ctlData,
           const void*           presParams,
           IWindow::SiblingOrder ordering = defaultOrdering() );

#endif // IC_PMWIN
#ifdef IC_MOTIF
IWindowHandle
  create ( unsigned long         id,
           const char*           title,
           unsigned long         style,
           IXmCreateFunction     createFunction,
           const IWindowHandle&  parent,
           const IWindowHandle&  owner,
           const IRectangle&     initRect,
           const void*           callerArgList,
           unsigned int          callerNumberArguments,
           IWindow::SiblingOrder ordering = defaultOrdering(),
           unsigned long         extendedStyle = 0 );
IWindowHandle
  create ( unsigned long         id,
           const char*           title,
           const IBitFlag&       style,
           IXmCreateFunction     createFunction,
           const IWindow*        parent,
           const IWindow*        owner,
           const IRectangle&     initRect,
           IWindow::SiblingOrder ordering = defaultOrdering() );
#endif // IC_MOTIF

virtual IFrameWindow
 &setDefaultPushButton     ( const IWindowHandle& defaultPushButton ),
 &setDefaultEmphasisButton ( const IWindowHandle& defaultEmphasisButton,
                             bool                 enable );

#ifdef IC_MOTIFWIN
/*---------------------- Event-Handling Implementation -----------------------*/

virtual bool
  passEventToOwner ( IEvent& event );
#endif

IFrameWindow
 &start  ( const IWindowHandle& hwnd );

IFrameWindow
 &addDefaultHandler    ( ),
 &removeDefaultHandler ( );

private:
/*------------------------------ Hidden Members ------------------------------*/
  IFrameWindow ( const IFrameWindow& frame );
IFrameWindow
 &operator=    ( const IFrameWindow& frame );

/*--------------------------------- Private ----------------------------------*/
friend class IFrameHandler;
friend class IFrameWindowNotifyHandler;
friend class IMenuBar;
friend class ICurrentThread;
friend class IMenuPrivate;

#ifdef IC_MOTIF
static IFrameWindow* currentModalFrameWindow;
#endif // IC_MOTIF

IFrameWindow
 &addExtension ( IFrameExtension* extension );

static const Style
  IC_IMPORTU styleBits;
static Style
  currentDefault;

static IWindow::SiblingOrder
  siblingCreateOrder;

IFrameWindowData
 *fFrameWindowData;

IFrameWindow::Style
  fCopyOfStyle;
}; // IFrameWindow

INESTEDBITFLAGCLASSFUNCS(Style, IFrameWindow)

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _IFRAME_
